/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsClient;
import software.amazon.awssdk.services.ivs.model.ListChannelsRequest;
import software.amazon.awssdk.services.ivs.model.ListChannelsResponse;

public class ListChannelsIterable
implements SdkIterable<ListChannelsResponse> {
    private final IvsClient client;
    private final ListChannelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelsIterable(IvsClient client, ListChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListChannelsResponseFetcher();
    }

    public Iterator<ListChannelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChannelsResponseFetcher
    implements SyncPageFetcher<ListChannelsResponse> {
        private ListChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelsResponse nextPage(ListChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelsIterable.this.client.listChannels(ListChannelsIterable.this.firstRequest);
            }
            return ListChannelsIterable.this.client.listChannels((ListChannelsRequest)((Object)ListChannelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

