/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.StreamHealth;
import software.amazon.awssdk.services.ivs.model.StreamState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamSummary> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamSummary.getter(StreamSummary::channelArn)).setter(StreamSummary.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamSummary.getter(StreamSummary::stateAsString)).setter(StreamSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamSummary.getter(StreamSummary::healthAsString)).setter(StreamSummary.setter(Builder::health)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()}).build();
    private static final SdkField<Long> VIEWER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(StreamSummary.getter(StreamSummary::viewerCount)).setter(StreamSummary.setter(Builder::viewerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewerCount").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StreamSummary.getter(StreamSummary::startTime)).setter(StreamSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, STATE_FIELD, HEALTH_FIELD, VIEWER_COUNT_FIELD, START_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String channelArn;
    private final String state;
    private final String health;
    private final Long viewerCount;
    private final Instant startTime;

    private StreamSummary(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.state = builder.state;
        this.health = builder.health;
        this.viewerCount = builder.viewerCount;
        this.startTime = builder.startTime;
    }

    public String channelArn() {
        return this.channelArn;
    }

    public StreamState state() {
        return StreamState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public StreamHealth health() {
        return StreamHealth.fromValue(this.health);
    }

    public String healthAsString() {
        return this.health;
    }

    public Long viewerCount() {
        return this.viewerCount;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSummary)) {
            return false;
        }
        StreamSummary other = (StreamSummary)obj;
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.healthAsString(), other.healthAsString()) && Objects.equals(this.viewerCount(), other.viewerCount()) && Objects.equals(this.startTime(), other.startTime());
    }

    public String toString() {
        return ToString.builder((String)"StreamSummary").add("ChannelArn", (Object)this.channelArn()).add("State", (Object)this.stateAsString()).add("Health", (Object)this.healthAsString()).add("ViewerCount", (Object)this.viewerCount()).add("StartTime", (Object)this.startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "health": {
                return Optional.ofNullable(clazz.cast(this.healthAsString()));
            }
            case "viewerCount": {
                return Optional.ofNullable(clazz.cast(this.viewerCount()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamSummary, T> g) {
        return obj -> g.apply((StreamSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelArn;
        private String state;
        private String health;
        private Long viewerCount;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSummary model) {
            this.channelArn(model.channelArn);
            this.state(model.state);
            this.health(model.health);
            this.viewerCount(model.viewerCount);
            this.startTime(model.startTime);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StreamState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getHealth() {
            return this.health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(StreamHealth health) {
            this.health(health == null ? null : health.toString());
            return this;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        public final Long getViewerCount() {
            return this.viewerCount;
        }

        @Override
        public final Builder viewerCount(Long viewerCount) {
            this.viewerCount = viewerCount;
            return this;
        }

        public final void setViewerCount(Long viewerCount) {
            this.viewerCount = viewerCount;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public StreamSummary build() {
            return new StreamSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamSummary> {
        public Builder channelArn(String var1);

        public Builder state(String var1);

        public Builder state(StreamState var1);

        public Builder health(String var1);

        public Builder health(StreamHealth var1);

        public Builder viewerCount(Long var1);

        public Builder startTime(Instant var1);
    }
}

