/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivs.model.ChannelLatencyMode;
import software.amazon.awssdk.services.ivs.model.ChannelType;
import software.amazon.awssdk.services.ivs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Channel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Channel> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::arn)).setter(Channel.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::name)).setter(Channel.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::latencyModeAsString)).setter(Channel.setter(Builder::latencyMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::typeAsString)).setter(Channel.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> INGEST_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::ingestEndpoint)).setter(Channel.setter(Builder::ingestEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestEndpoint").build()}).build();
    private static final SdkField<String> PLAYBACK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::playbackUrl)).setter(Channel.setter(Builder::playbackUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackUrl").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Channel.getter(Channel::tags)).setter(Channel.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, LATENCY_MODE_FIELD, TYPE_FIELD, INGEST_ENDPOINT_FIELD, PLAYBACK_URL_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String latencyMode;
    private final String type;
    private final String ingestEndpoint;
    private final String playbackUrl;
    private final Map<String, String> tags;

    private Channel(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.latencyMode = builder.latencyMode;
        this.type = builder.type;
        this.ingestEndpoint = builder.ingestEndpoint;
        this.playbackUrl = builder.playbackUrl;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(this.latencyMode);
    }

    public String latencyModeAsString() {
        return this.latencyMode;
    }

    public ChannelType type() {
        return ChannelType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String ingestEndpoint() {
        return this.ingestEndpoint;
    }

    public String playbackUrl() {
        return this.playbackUrl;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.latencyModeAsString(), other.latencyModeAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.ingestEndpoint(), other.ingestEndpoint()) && Objects.equals(this.playbackUrl(), other.playbackUrl()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"Channel").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("LatencyMode", (Object)this.latencyModeAsString()).add("Type", (Object)this.typeAsString()).add("IngestEndpoint", (Object)this.ingestEndpoint()).add("PlaybackUrl", (Object)this.playbackUrl()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "latencyMode": {
                return Optional.ofNullable(clazz.cast(this.latencyModeAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ingestEndpoint": {
                return Optional.ofNullable(clazz.cast(this.ingestEndpoint()));
            }
            case "playbackUrl": {
                return Optional.ofNullable(clazz.cast(this.playbackUrl()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String latencyMode;
        private String type;
        private String ingestEndpoint;
        private String playbackUrl;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            this.arn(model.arn);
            this.name(model.name);
            this.latencyMode(model.latencyMode);
            this.type(model.type);
            this.ingestEndpoint(model.ingestEndpoint);
            this.playbackUrl(model.playbackUrl);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLatencyMode() {
            return this.latencyMode;
        }

        @Override
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getIngestEndpoint() {
            return this.ingestEndpoint;
        }

        @Override
        public final Builder ingestEndpoint(String ingestEndpoint) {
            this.ingestEndpoint = ingestEndpoint;
            return this;
        }

        public final void setIngestEndpoint(String ingestEndpoint) {
            this.ingestEndpoint = ingestEndpoint;
        }

        public final String getPlaybackUrl() {
            return this.playbackUrl;
        }

        @Override
        public final Builder playbackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
            return this;
        }

        public final void setPlaybackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public Channel build() {
            return new Channel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Channel> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder latencyMode(String var1);

        public Builder latencyMode(ChannelLatencyMode var1);

        public Builder type(String var1);

        public Builder type(ChannelType var1);

        public Builder ingestEndpoint(String var1);

        public Builder playbackUrl(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

