/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.IvsRequest;
import software.amazon.awssdk.services.ivs.model.StreamKeyArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetStreamKeyRequest
extends IvsRequest
implements ToCopyableBuilder<Builder, BatchGetStreamKeyRequest> {
    private static final SdkField<List<String>> ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetStreamKeyRequest.getter(BatchGetStreamKeyRequest::arns)).setter(BatchGetStreamKeyRequest.setter(Builder::arns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARNS_FIELD));
    private final List<String> arns;

    private BatchGetStreamKeyRequest(BuilderImpl builder) {
        super(builder);
        this.arns = builder.arns;
    }

    public boolean hasArns() {
        return this.arns != null && !(this.arns instanceof SdkAutoConstructList);
    }

    public List<String> arns() {
        return this.arns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetStreamKeyRequest)) {
            return false;
        }
        BatchGetStreamKeyRequest other = (BatchGetStreamKeyRequest)((Object)obj);
        return Objects.equals(this.arns(), other.arns());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetStreamKeyRequest").add("Arns", this.arns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arns": {
                return Optional.ofNullable(clazz.cast(this.arns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetStreamKeyRequest, T> g) {
        return obj -> g.apply((BatchGetStreamKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRequest.BuilderImpl
    implements Builder {
        private List<String> arns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetStreamKeyRequest model) {
            super(model);
            this.arns(model.arns);
        }

        public final Collection<String> getArns() {
            return this.arns;
        }

        @Override
        public final Builder arns(Collection<String> arns) {
            this.arns = StreamKeyArnListCopier.copy(arns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arns(String ... arns) {
            this.arns(Arrays.asList(arns));
            return this;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = StreamKeyArnListCopier.copy(arns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetStreamKeyRequest build() {
            return new BatchGetStreamKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetStreamKeyRequest> {
        public Builder arns(Collection<String> var1);

        public Builder arns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

