/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.CertificateList;
import software.amazon.awssdk.services.iotwireless.model.DeviceCertificateListCopier;
import software.amazon.awssdk.services.iotwireless.model.SidewalkPositioning;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SidewalkListDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SidewalkListDevice> {
    private static final SdkField<String> AMAZON_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmazonId").getter(SidewalkListDevice.getter(SidewalkListDevice::amazonId)).setter(SidewalkListDevice.setter(Builder::amazonId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonId").build()}).build();
    private static final SdkField<String> SIDEWALK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SidewalkId").getter(SidewalkListDevice.getter(SidewalkListDevice::sidewalkId)).setter(SidewalkListDevice.setter(Builder::sidewalkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkId").build()}).build();
    private static final SdkField<String> SIDEWALK_MANUFACTURING_SN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SidewalkManufacturingSn").getter(SidewalkListDevice.getter(SidewalkListDevice::sidewalkManufacturingSn)).setter(SidewalkListDevice.setter(Builder::sidewalkManufacturingSn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkManufacturingSn").build()}).build();
    private static final SdkField<List<CertificateList>> DEVICE_CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceCertificates").getter(SidewalkListDevice.getter(SidewalkListDevice::deviceCertificates)).setter(SidewalkListDevice.setter(Builder::deviceCertificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceCertificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CertificateList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceProfileId").getter(SidewalkListDevice.getter(SidewalkListDevice::deviceProfileId)).setter(SidewalkListDevice.setter(Builder::deviceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceProfileId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SidewalkListDevice.getter(SidewalkListDevice::statusAsString)).setter(SidewalkListDevice.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<SidewalkPositioning> POSITIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Positioning").getter(SidewalkListDevice.getter(SidewalkListDevice::positioning)).setter(SidewalkListDevice.setter(Builder::positioning)).constructor(SidewalkPositioning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_ID_FIELD, SIDEWALK_ID_FIELD, SIDEWALK_MANUFACTURING_SN_FIELD, DEVICE_CERTIFICATES_FIELD, DEVICE_PROFILE_ID_FIELD, STATUS_FIELD, POSITIONING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SidewalkListDevice.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String amazonId;
    private final String sidewalkId;
    private final String sidewalkManufacturingSn;
    private final List<CertificateList> deviceCertificates;
    private final String deviceProfileId;
    private final String status;
    private final SidewalkPositioning positioning;

    private SidewalkListDevice(BuilderImpl builder) {
        this.amazonId = builder.amazonId;
        this.sidewalkId = builder.sidewalkId;
        this.sidewalkManufacturingSn = builder.sidewalkManufacturingSn;
        this.deviceCertificates = builder.deviceCertificates;
        this.deviceProfileId = builder.deviceProfileId;
        this.status = builder.status;
        this.positioning = builder.positioning;
    }

    public final String amazonId() {
        return this.amazonId;
    }

    public final String sidewalkId() {
        return this.sidewalkId;
    }

    public final String sidewalkManufacturingSn() {
        return this.sidewalkManufacturingSn;
    }

    public final boolean hasDeviceCertificates() {
        return this.deviceCertificates != null && !(this.deviceCertificates instanceof SdkAutoConstructList);
    }

    public final List<CertificateList> deviceCertificates() {
        return this.deviceCertificates;
    }

    public final String deviceProfileId() {
        return this.deviceProfileId;
    }

    public final WirelessDeviceSidewalkStatus status() {
        return WirelessDeviceSidewalkStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SidewalkPositioning positioning() {
        return this.positioning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalkManufacturingSn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceCertificates() ? this.deviceCertificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.positioning());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkListDevice)) {
            return false;
        }
        SidewalkListDevice other = (SidewalkListDevice)obj;
        return Objects.equals(this.amazonId(), other.amazonId()) && Objects.equals(this.sidewalkId(), other.sidewalkId()) && Objects.equals(this.sidewalkManufacturingSn(), other.sidewalkManufacturingSn()) && this.hasDeviceCertificates() == other.hasDeviceCertificates() && Objects.equals(this.deviceCertificates(), other.deviceCertificates()) && Objects.equals(this.deviceProfileId(), other.deviceProfileId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.positioning(), other.positioning());
    }

    public final String toString() {
        return ToString.builder((String)"SidewalkListDevice").add("AmazonId", (Object)this.amazonId()).add("SidewalkId", (Object)this.sidewalkId()).add("SidewalkManufacturingSn", (Object)this.sidewalkManufacturingSn()).add("DeviceCertificates", this.hasDeviceCertificates() ? this.deviceCertificates() : null).add("DeviceProfileId", (Object)this.deviceProfileId()).add("Status", (Object)this.statusAsString()).add("Positioning", (Object)this.positioning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonId": {
                return Optional.ofNullable(clazz.cast(this.amazonId()));
            }
            case "SidewalkId": {
                return Optional.ofNullable(clazz.cast(this.sidewalkId()));
            }
            case "SidewalkManufacturingSn": {
                return Optional.ofNullable(clazz.cast(this.sidewalkManufacturingSn()));
            }
            case "DeviceCertificates": {
                return Optional.ofNullable(clazz.cast(this.deviceCertificates()));
            }
            case "DeviceProfileId": {
                return Optional.ofNullable(clazz.cast(this.deviceProfileId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Positioning": {
                return Optional.ofNullable(clazz.cast(this.positioning()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AmazonId", AMAZON_ID_FIELD);
        map.put("SidewalkId", SIDEWALK_ID_FIELD);
        map.put("SidewalkManufacturingSn", SIDEWALK_MANUFACTURING_SN_FIELD);
        map.put("DeviceCertificates", DEVICE_CERTIFICATES_FIELD);
        map.put("DeviceProfileId", DEVICE_PROFILE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Positioning", POSITIONING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SidewalkListDevice, T> g) {
        return obj -> g.apply((SidewalkListDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String amazonId;
        private String sidewalkId;
        private String sidewalkManufacturingSn;
        private List<CertificateList> deviceCertificates = DefaultSdkAutoConstructList.getInstance();
        private String deviceProfileId;
        private String status;
        private SidewalkPositioning positioning;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkListDevice model) {
            this.amazonId(model.amazonId);
            this.sidewalkId(model.sidewalkId);
            this.sidewalkManufacturingSn(model.sidewalkManufacturingSn);
            this.deviceCertificates(model.deviceCertificates);
            this.deviceProfileId(model.deviceProfileId);
            this.status(model.status);
            this.positioning(model.positioning);
        }

        public final String getAmazonId() {
            return this.amazonId;
        }

        public final void setAmazonId(String amazonId) {
            this.amazonId = amazonId;
        }

        @Override
        public final Builder amazonId(String amazonId) {
            this.amazonId = amazonId;
            return this;
        }

        public final String getSidewalkId() {
            return this.sidewalkId;
        }

        public final void setSidewalkId(String sidewalkId) {
            this.sidewalkId = sidewalkId;
        }

        @Override
        public final Builder sidewalkId(String sidewalkId) {
            this.sidewalkId = sidewalkId;
            return this;
        }

        public final String getSidewalkManufacturingSn() {
            return this.sidewalkManufacturingSn;
        }

        public final void setSidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
        }

        @Override
        public final Builder sidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
            return this;
        }

        public final List<CertificateList.Builder> getDeviceCertificates() {
            List<CertificateList.Builder> result = DeviceCertificateListCopier.copyToBuilder(this.deviceCertificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceCertificates(Collection<CertificateList.BuilderImpl> deviceCertificates) {
            this.deviceCertificates = DeviceCertificateListCopier.copyFromBuilder(deviceCertificates);
        }

        @Override
        public final Builder deviceCertificates(Collection<CertificateList> deviceCertificates) {
            this.deviceCertificates = DeviceCertificateListCopier.copy(deviceCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceCertificates(CertificateList ... deviceCertificates) {
            this.deviceCertificates(Arrays.asList(deviceCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceCertificates(Consumer<CertificateList.Builder> ... deviceCertificates) {
            this.deviceCertificates(Stream.of(deviceCertificates).map(c -> (CertificateList)((CertificateList.Builder)CertificateList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDeviceProfileId() {
            return this.deviceProfileId;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WirelessDeviceSidewalkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final SidewalkPositioning.Builder getPositioning() {
            return this.positioning != null ? this.positioning.toBuilder() : null;
        }

        public final void setPositioning(SidewalkPositioning.BuilderImpl positioning) {
            this.positioning = positioning != null ? positioning.build() : null;
        }

        @Override
        public final Builder positioning(SidewalkPositioning positioning) {
            this.positioning = positioning;
            return this;
        }

        public SidewalkListDevice build() {
            return new SidewalkListDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SidewalkListDevice> {
        public Builder amazonId(String var1);

        public Builder sidewalkId(String var1);

        public Builder sidewalkManufacturingSn(String var1);

        public Builder deviceCertificates(Collection<CertificateList> var1);

        public Builder deviceCertificates(CertificateList ... var1);

        public Builder deviceCertificates(Consumer<CertificateList.Builder> ... var1);

        public Builder deviceProfileId(String var1);

        public Builder status(String var1);

        public Builder status(WirelessDeviceSidewalkStatus var1);

        public Builder positioning(SidewalkPositioning var1);

        default public Builder positioning(Consumer<SidewalkPositioning.Builder> positioning) {
            return this.positioning((SidewalkPositioning)((SidewalkPositioning.Builder)SidewalkPositioning.builder().applyMutation(positioning)).build());
        }
    }
}

