/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice;
import software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDeviceListCopier;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.PositioningConfigStatus;
import software.amazon.awssdk.services.iotwireless.model.SidewalkListDevicesForImportInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicesForWirelessDeviceImportTaskResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListDevicesForWirelessDeviceImportTaskResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDevicesForWirelessDeviceImportTaskResponse.getter(ListDevicesForWirelessDeviceImportTaskResponse::nextToken)).setter(ListDevicesForWirelessDeviceImportTaskResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(ListDevicesForWirelessDeviceImportTaskResponse.getter(ListDevicesForWirelessDeviceImportTaskResponse::destinationName)).setter(ListDevicesForWirelessDeviceImportTaskResponse.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()}).build();
    private static final SdkField<String> POSITIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Positioning").getter(ListDevicesForWirelessDeviceImportTaskResponse.getter(ListDevicesForWirelessDeviceImportTaskResponse::positioningAsString)).setter(ListDevicesForWirelessDeviceImportTaskResponse.setter(Builder::positioning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()}).build();
    private static final SdkField<SidewalkListDevicesForImportInfo> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(ListDevicesForWirelessDeviceImportTaskResponse.getter(ListDevicesForWirelessDeviceImportTaskResponse::sidewalk)).setter(ListDevicesForWirelessDeviceImportTaskResponse.setter(Builder::sidewalk)).constructor(SidewalkListDevicesForImportInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final SdkField<List<ImportedWirelessDevice>> IMPORTED_WIRELESS_DEVICE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImportedWirelessDeviceList").getter(ListDevicesForWirelessDeviceImportTaskResponse.getter(ListDevicesForWirelessDeviceImportTaskResponse::importedWirelessDeviceList)).setter(ListDevicesForWirelessDeviceImportTaskResponse.setter(Builder::importedWirelessDeviceList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedWirelessDeviceList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportedWirelessDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DESTINATION_NAME_FIELD, POSITIONING_FIELD, SIDEWALK_FIELD, IMPORTED_WIRELESS_DEVICE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDevicesForWirelessDeviceImportTaskResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final String destinationName;
    private final String positioning;
    private final SidewalkListDevicesForImportInfo sidewalk;
    private final List<ImportedWirelessDevice> importedWirelessDeviceList;

    private ListDevicesForWirelessDeviceImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.destinationName = builder.destinationName;
        this.positioning = builder.positioning;
        this.sidewalk = builder.sidewalk;
        this.importedWirelessDeviceList = builder.importedWirelessDeviceList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final PositioningConfigStatus positioning() {
        return PositioningConfigStatus.fromValue(this.positioning);
    }

    public final String positioningAsString() {
        return this.positioning;
    }

    public final SidewalkListDevicesForImportInfo sidewalk() {
        return this.sidewalk;
    }

    public final boolean hasImportedWirelessDeviceList() {
        return this.importedWirelessDeviceList != null && !(this.importedWirelessDeviceList instanceof SdkAutoConstructList);
    }

    public final List<ImportedWirelessDevice> importedWirelessDeviceList() {
        return this.importedWirelessDeviceList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.positioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportedWirelessDeviceList() ? this.importedWirelessDeviceList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesForWirelessDeviceImportTaskResponse)) {
            return false;
        }
        ListDevicesForWirelessDeviceImportTaskResponse other = (ListDevicesForWirelessDeviceImportTaskResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.positioningAsString(), other.positioningAsString()) && Objects.equals(this.sidewalk(), other.sidewalk()) && this.hasImportedWirelessDeviceList() == other.hasImportedWirelessDeviceList() && Objects.equals(this.importedWirelessDeviceList(), other.importedWirelessDeviceList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevicesForWirelessDeviceImportTaskResponse").add("NextToken", (Object)this.nextToken()).add("DestinationName", (Object)this.destinationName()).add("Positioning", (Object)this.positioningAsString()).add("Sidewalk", (Object)this.sidewalk()).add("ImportedWirelessDeviceList", this.hasImportedWirelessDeviceList() ? this.importedWirelessDeviceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "Positioning": {
                return Optional.ofNullable(clazz.cast(this.positioningAsString()));
            }
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
            case "ImportedWirelessDeviceList": {
                return Optional.ofNullable(clazz.cast(this.importedWirelessDeviceList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DestinationName", DESTINATION_NAME_FIELD);
        map.put("Positioning", POSITIONING_FIELD);
        map.put("Sidewalk", SIDEWALK_FIELD);
        map.put("ImportedWirelessDeviceList", IMPORTED_WIRELESS_DEVICE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesForWirelessDeviceImportTaskResponse, T> g) {
        return obj -> g.apply((ListDevicesForWirelessDeviceImportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private String destinationName;
        private String positioning;
        private SidewalkListDevicesForImportInfo sidewalk;
        private List<ImportedWirelessDevice> importedWirelessDeviceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesForWirelessDeviceImportTaskResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.destinationName(model.destinationName);
            this.positioning(model.positioning);
            this.sidewalk(model.sidewalk);
            this.importedWirelessDeviceList(model.importedWirelessDeviceList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getPositioning() {
            return this.positioning;
        }

        public final void setPositioning(String positioning) {
            this.positioning = positioning;
        }

        @Override
        public final Builder positioning(String positioning) {
            this.positioning = positioning;
            return this;
        }

        @Override
        public final Builder positioning(PositioningConfigStatus positioning) {
            this.positioning(positioning == null ? null : positioning.toString());
            return this;
        }

        public final SidewalkListDevicesForImportInfo.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkListDevicesForImportInfo.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkListDevicesForImportInfo sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final List<ImportedWirelessDevice.Builder> getImportedWirelessDeviceList() {
            List<ImportedWirelessDevice.Builder> result = ImportedWirelessDeviceListCopier.copyToBuilder(this.importedWirelessDeviceList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportedWirelessDeviceList(Collection<ImportedWirelessDevice.BuilderImpl> importedWirelessDeviceList) {
            this.importedWirelessDeviceList = ImportedWirelessDeviceListCopier.copyFromBuilder(importedWirelessDeviceList);
        }

        @Override
        public final Builder importedWirelessDeviceList(Collection<ImportedWirelessDevice> importedWirelessDeviceList) {
            this.importedWirelessDeviceList = ImportedWirelessDeviceListCopier.copy(importedWirelessDeviceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importedWirelessDeviceList(ImportedWirelessDevice ... importedWirelessDeviceList) {
            this.importedWirelessDeviceList(Arrays.asList(importedWirelessDeviceList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importedWirelessDeviceList(Consumer<ImportedWirelessDevice.Builder> ... importedWirelessDeviceList) {
            this.importedWirelessDeviceList(Stream.of(importedWirelessDeviceList).map(c -> (ImportedWirelessDevice)((ImportedWirelessDevice.Builder)ImportedWirelessDevice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDevicesForWirelessDeviceImportTaskResponse build() {
            return new ListDevicesForWirelessDeviceImportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDevicesForWirelessDeviceImportTaskResponse> {
        public Builder nextToken(String var1);

        public Builder destinationName(String var1);

        public Builder positioning(String var1);

        public Builder positioning(PositioningConfigStatus var1);

        public Builder sidewalk(SidewalkListDevicesForImportInfo var1);

        default public Builder sidewalk(Consumer<SidewalkListDevicesForImportInfo.Builder> sidewalk) {
            return this.sidewalk((SidewalkListDevicesForImportInfo)((SidewalkListDevicesForImportInfo.Builder)SidewalkListDevicesForImportInfo.builder().applyMutation(sidewalk)).build());
        }

        public Builder importedWirelessDeviceList(Collection<ImportedWirelessDevice> var1);

        public Builder importedWirelessDeviceList(ImportedWirelessDevice ... var1);

        public Builder importedWirelessDeviceList(Consumer<ImportedWirelessDevice.Builder> ... var1);
    }
}

