/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.Accuracy;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.PositionCoordinateCopier;
import software.amazon.awssdk.services.iotwireless.model.PositionSolverProvider;
import software.amazon.awssdk.services.iotwireless.model.PositionSolverType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPositionResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetPositionResponse> {
    private static final SdkField<List<Float>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(GetPositionResponse.getter(GetPositionResponse::position)).setter(GetPositionResponse.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.FLOAT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Accuracy> ACCURACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Accuracy").getter(GetPositionResponse.getter(GetPositionResponse::accuracy)).setter(GetPositionResponse.setter(Builder::accuracy)).constructor(Accuracy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accuracy").build()}).build();
    private static final SdkField<String> SOLVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SolverType").getter(GetPositionResponse.getter(GetPositionResponse::solverTypeAsString)).setter(GetPositionResponse.setter(Builder::solverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolverType").build()}).build();
    private static final SdkField<String> SOLVER_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SolverProvider").getter(GetPositionResponse.getter(GetPositionResponse::solverProviderAsString)).setter(GetPositionResponse.setter(Builder::solverProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolverProvider").build()}).build();
    private static final SdkField<String> SOLVER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SolverVersion").getter(GetPositionResponse.getter(GetPositionResponse::solverVersion)).setter(GetPositionResponse.setter(Builder::solverVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolverVersion").build()}).build();
    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timestamp").getter(GetPositionResponse.getter(GetPositionResponse::timestamp)).setter(GetPositionResponse.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, ACCURACY_FIELD, SOLVER_TYPE_FIELD, SOLVER_PROVIDER_FIELD, SOLVER_VERSION_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Position", POSITION_FIELD);
            this.put("Accuracy", ACCURACY_FIELD);
            this.put("SolverType", SOLVER_TYPE_FIELD);
            this.put("SolverProvider", SOLVER_PROVIDER_FIELD);
            this.put("SolverVersion", SOLVER_VERSION_FIELD);
            this.put("Timestamp", TIMESTAMP_FIELD);
        }
    });
    private final List<Float> position;
    private final Accuracy accuracy;
    private final String solverType;
    private final String solverProvider;
    private final String solverVersion;
    private final String timestamp;

    private GetPositionResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.accuracy = builder.accuracy;
        this.solverType = builder.solverType;
        this.solverProvider = builder.solverProvider;
        this.solverVersion = builder.solverVersion;
        this.timestamp = builder.timestamp;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Float> position() {
        return this.position;
    }

    public final Accuracy accuracy() {
        return this.accuracy;
    }

    public final PositionSolverType solverType() {
        return PositionSolverType.fromValue(this.solverType);
    }

    public final String solverTypeAsString() {
        return this.solverType;
    }

    public final PositionSolverProvider solverProvider() {
        return PositionSolverProvider.fromValue(this.solverProvider);
    }

    public final String solverProviderAsString() {
        return this.solverProvider;
    }

    public final String solverVersion() {
        return this.solverVersion;
    }

    public final String timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accuracy());
        hashCode = 31 * hashCode + Objects.hashCode(this.solverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.solverProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.solverVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPositionResponse)) {
            return false;
        }
        GetPositionResponse other = (GetPositionResponse)((Object)obj);
        return this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.accuracy(), other.accuracy()) && Objects.equals(this.solverTypeAsString(), other.solverTypeAsString()) && Objects.equals(this.solverProviderAsString(), other.solverProviderAsString()) && Objects.equals(this.solverVersion(), other.solverVersion()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetPositionResponse").add("Position", this.hasPosition() ? this.position() : null).add("Accuracy", (Object)this.accuracy()).add("SolverType", (Object)this.solverTypeAsString()).add("SolverProvider", (Object)this.solverProviderAsString()).add("SolverVersion", (Object)this.solverVersion()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "Accuracy": {
                return Optional.ofNullable(clazz.cast(this.accuracy()));
            }
            case "SolverType": {
                return Optional.ofNullable(clazz.cast(this.solverTypeAsString()));
            }
            case "SolverProvider": {
                return Optional.ofNullable(clazz.cast(this.solverProviderAsString()));
            }
            case "SolverVersion": {
                return Optional.ofNullable(clazz.cast(this.solverVersion()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetPositionResponse, T> g) {
        return obj -> g.apply((GetPositionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private List<Float> position = DefaultSdkAutoConstructList.getInstance();
        private Accuracy accuracy;
        private String solverType;
        private String solverProvider;
        private String solverVersion;
        private String timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPositionResponse model) {
            super(model);
            this.position(model.position);
            this.accuracy(model.accuracy);
            this.solverType(model.solverType);
            this.solverProvider(model.solverProvider);
            this.solverVersion(model.solverVersion);
            this.timestamp(model.timestamp);
        }

        public final Collection<Float> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Float> position) {
            this.position = PositionCoordinateCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Float> position) {
            this.position = PositionCoordinateCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Float ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final Accuracy.Builder getAccuracy() {
            return this.accuracy != null ? this.accuracy.toBuilder() : null;
        }

        public final void setAccuracy(Accuracy.BuilderImpl accuracy) {
            this.accuracy = accuracy != null ? accuracy.build() : null;
        }

        @Override
        public final Builder accuracy(Accuracy accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public final String getSolverType() {
            return this.solverType;
        }

        public final void setSolverType(String solverType) {
            this.solverType = solverType;
        }

        @Override
        public final Builder solverType(String solverType) {
            this.solverType = solverType;
            return this;
        }

        @Override
        public final Builder solverType(PositionSolverType solverType) {
            this.solverType(solverType == null ? null : solverType.toString());
            return this;
        }

        public final String getSolverProvider() {
            return this.solverProvider;
        }

        public final void setSolverProvider(String solverProvider) {
            this.solverProvider = solverProvider;
        }

        @Override
        public final Builder solverProvider(String solverProvider) {
            this.solverProvider = solverProvider;
            return this;
        }

        @Override
        public final Builder solverProvider(PositionSolverProvider solverProvider) {
            this.solverProvider(solverProvider == null ? null : solverProvider.toString());
            return this;
        }

        public final String getSolverVersion() {
            return this.solverVersion;
        }

        public final void setSolverVersion(String solverVersion) {
            this.solverVersion = solverVersion;
        }

        @Override
        public final Builder solverVersion(String solverVersion) {
            this.solverVersion = solverVersion;
            return this;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public GetPositionResponse build() {
            return new GetPositionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPositionResponse> {
        public Builder position(Collection<Float> var1);

        public Builder position(Float ... var1);

        public Builder accuracy(Accuracy var1);

        default public Builder accuracy(Consumer<Accuracy.Builder> accuracy) {
            return this.accuracy((Accuracy)((Accuracy.Builder)Accuracy.builder().applyMutation(accuracy)).build());
        }

        public Builder solverType(String var1);

        public Builder solverType(PositionSolverType var1);

        public Builder solverProvider(String var1);

        public Builder solverProvider(PositionSolverProvider var1);

        public Builder solverVersion(String var1);

        public Builder timestamp(String var1);
    }
}

