/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.DownlinkMode;
import software.amazon.awssdk.services.iotwireless.model.GatewayListCopier;
import software.amazon.awssdk.services.iotwireless.model.GatewayListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipatingGateways
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipatingGateways> {
    private static final SdkField<String> DOWNLINK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DownlinkMode").getter(ParticipatingGateways.getter(ParticipatingGateways::downlinkModeAsString)).setter(ParticipatingGateways.setter(Builder::downlinkMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownlinkMode").build()}).build();
    private static final SdkField<List<GatewayListItem>> GATEWAY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GatewayList").getter(ParticipatingGateways.getter(ParticipatingGateways::gatewayList)).setter(ParticipatingGateways.setter(Builder::gatewayList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GatewayListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TRANSMISSION_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TransmissionInterval").getter(ParticipatingGateways.getter(ParticipatingGateways::transmissionInterval)).setter(ParticipatingGateways.setter(Builder::transmissionInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransmissionInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOWNLINK_MODE_FIELD, GATEWAY_LIST_FIELD, TRANSMISSION_INTERVAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DownlinkMode", DOWNLINK_MODE_FIELD);
            this.put("GatewayList", GATEWAY_LIST_FIELD);
            this.put("TransmissionInterval", TRANSMISSION_INTERVAL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String downlinkMode;
    private final List<GatewayListItem> gatewayList;
    private final Integer transmissionInterval;

    private ParticipatingGateways(BuilderImpl builder) {
        this.downlinkMode = builder.downlinkMode;
        this.gatewayList = builder.gatewayList;
        this.transmissionInterval = builder.transmissionInterval;
    }

    public final DownlinkMode downlinkMode() {
        return DownlinkMode.fromValue(this.downlinkMode);
    }

    public final String downlinkModeAsString() {
        return this.downlinkMode;
    }

    public final boolean hasGatewayList() {
        return this.gatewayList != null && !(this.gatewayList instanceof SdkAutoConstructList);
    }

    public final List<GatewayListItem> gatewayList() {
        return this.gatewayList;
    }

    public final Integer transmissionInterval() {
        return this.transmissionInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewayList() ? this.gatewayList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transmissionInterval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingGateways)) {
            return false;
        }
        ParticipatingGateways other = (ParticipatingGateways)obj;
        return Objects.equals(this.downlinkModeAsString(), other.downlinkModeAsString()) && this.hasGatewayList() == other.hasGatewayList() && Objects.equals(this.gatewayList(), other.gatewayList()) && Objects.equals(this.transmissionInterval(), other.transmissionInterval());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipatingGateways").add("DownlinkMode", (Object)this.downlinkModeAsString()).add("GatewayList", this.hasGatewayList() ? this.gatewayList() : null).add("TransmissionInterval", (Object)this.transmissionInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DownlinkMode": {
                return Optional.ofNullable(clazz.cast(this.downlinkModeAsString()));
            }
            case "GatewayList": {
                return Optional.ofNullable(clazz.cast(this.gatewayList()));
            }
            case "TransmissionInterval": {
                return Optional.ofNullable(clazz.cast(this.transmissionInterval()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingGateways, T> g) {
        return obj -> g.apply((ParticipatingGateways)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String downlinkMode;
        private List<GatewayListItem> gatewayList = DefaultSdkAutoConstructList.getInstance();
        private Integer transmissionInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingGateways model) {
            this.downlinkMode(model.downlinkMode);
            this.gatewayList(model.gatewayList);
            this.transmissionInterval(model.transmissionInterval);
        }

        public final String getDownlinkMode() {
            return this.downlinkMode;
        }

        public final void setDownlinkMode(String downlinkMode) {
            this.downlinkMode = downlinkMode;
        }

        @Override
        public final Builder downlinkMode(String downlinkMode) {
            this.downlinkMode = downlinkMode;
            return this;
        }

        @Override
        public final Builder downlinkMode(DownlinkMode downlinkMode) {
            this.downlinkMode(downlinkMode == null ? null : downlinkMode.toString());
            return this;
        }

        public final List<GatewayListItem.Builder> getGatewayList() {
            List<GatewayListItem.Builder> result = GatewayListCopier.copyToBuilder(this.gatewayList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGatewayList(Collection<GatewayListItem.BuilderImpl> gatewayList) {
            this.gatewayList = GatewayListCopier.copyFromBuilder(gatewayList);
        }

        @Override
        public final Builder gatewayList(Collection<GatewayListItem> gatewayList) {
            this.gatewayList = GatewayListCopier.copy(gatewayList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayList(GatewayListItem ... gatewayList) {
            this.gatewayList(Arrays.asList(gatewayList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayList(Consumer<GatewayListItem.Builder> ... gatewayList) {
            this.gatewayList(Stream.of(gatewayList).map(c -> (GatewayListItem)((GatewayListItem.Builder)GatewayListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTransmissionInterval() {
            return this.transmissionInterval;
        }

        public final void setTransmissionInterval(Integer transmissionInterval) {
            this.transmissionInterval = transmissionInterval;
        }

        @Override
        public final Builder transmissionInterval(Integer transmissionInterval) {
            this.transmissionInterval = transmissionInterval;
            return this;
        }

        public ParticipatingGateways build() {
            return new ParticipatingGateways(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipatingGateways> {
        public Builder downlinkMode(String var1);

        public Builder downlinkMode(DownlinkMode var1);

        public Builder gatewayList(Collection<GatewayListItem> var1);

        public Builder gatewayList(GatewayListItem ... var1);

        public Builder gatewayList(Consumer<GatewayListItem.Builder> ... var1);

        public Builder transmissionInterval(Integer var1);
    }
}

