/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.PositionConfigurationItem;
import software.amazon.awssdk.services.iotwireless.model.PositionConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPositionConfigurationsResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListPositionConfigurationsResponse> {
    private static final SdkField<List<PositionConfigurationItem>> POSITION_CONFIGURATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PositionConfigurationList").getter(ListPositionConfigurationsResponse.getter(ListPositionConfigurationsResponse::positionConfigurationList)).setter(ListPositionConfigurationsResponse.setter(Builder::positionConfigurationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionConfigurationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PositionConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPositionConfigurationsResponse.getter(ListPositionConfigurationsResponse::nextToken)).setter(ListPositionConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_CONFIGURATION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PositionConfigurationList", POSITION_CONFIGURATION_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<PositionConfigurationItem> positionConfigurationList;
    private final String nextToken;

    private ListPositionConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.positionConfigurationList = builder.positionConfigurationList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPositionConfigurationList() {
        return this.positionConfigurationList != null && !(this.positionConfigurationList instanceof SdkAutoConstructList);
    }

    public final List<PositionConfigurationItem> positionConfigurationList() {
        return this.positionConfigurationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPositionConfigurationList() ? this.positionConfigurationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPositionConfigurationsResponse)) {
            return false;
        }
        ListPositionConfigurationsResponse other = (ListPositionConfigurationsResponse)((Object)obj);
        return this.hasPositionConfigurationList() == other.hasPositionConfigurationList() && Objects.equals(this.positionConfigurationList(), other.positionConfigurationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPositionConfigurationsResponse").add("PositionConfigurationList", this.hasPositionConfigurationList() ? this.positionConfigurationList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PositionConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.positionConfigurationList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPositionConfigurationsResponse, T> g) {
        return obj -> g.apply((ListPositionConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private List<PositionConfigurationItem> positionConfigurationList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPositionConfigurationsResponse model) {
            super(model);
            this.positionConfigurationList(model.positionConfigurationList);
            this.nextToken(model.nextToken);
        }

        public final List<PositionConfigurationItem.Builder> getPositionConfigurationList() {
            List<PositionConfigurationItem.Builder> result = PositionConfigurationListCopier.copyToBuilder(this.positionConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPositionConfigurationList(Collection<PositionConfigurationItem.BuilderImpl> positionConfigurationList) {
            this.positionConfigurationList = PositionConfigurationListCopier.copyFromBuilder(positionConfigurationList);
        }

        @Override
        public final Builder positionConfigurationList(Collection<PositionConfigurationItem> positionConfigurationList) {
            this.positionConfigurationList = PositionConfigurationListCopier.copy(positionConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder positionConfigurationList(PositionConfigurationItem ... positionConfigurationList) {
            this.positionConfigurationList(Arrays.asList(positionConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder positionConfigurationList(Consumer<PositionConfigurationItem.Builder> ... positionConfigurationList) {
            this.positionConfigurationList(Stream.of(positionConfigurationList).map(c -> (PositionConfigurationItem)((PositionConfigurationItem.Builder)PositionConfigurationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPositionConfigurationsResponse build() {
            return new ListPositionConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPositionConfigurationsResponse> {
        public Builder positionConfigurationList(Collection<PositionConfigurationItem> var1);

        public Builder positionConfigurationList(PositionConfigurationItem ... var1);

        public Builder positionConfigurationList(Consumer<PositionConfigurationItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

