/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.AssistPositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Gnss
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Gnss> {
    private static final SdkField<String> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Payload").getter(Gnss.getter(Gnss::payload)).setter(Gnss.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()}).build();
    private static final SdkField<Float> CAPTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("CaptureTime").getter(Gnss.getter(Gnss::captureTime)).setter(Gnss.setter(Builder::captureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureTime").build()}).build();
    private static final SdkField<Float> CAPTURE_TIME_ACCURACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("CaptureTimeAccuracy").getter(Gnss.getter(Gnss::captureTimeAccuracy)).setter(Gnss.setter(Builder::captureTimeAccuracy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureTimeAccuracy").build()}).build();
    private static final SdkField<List<Float>> ASSIST_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssistPosition").getter(Gnss.getter(Gnss::assistPosition)).setter(Gnss.setter(Builder::assistPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssistPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.FLOAT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> ASSIST_ALTITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("AssistAltitude").getter(Gnss.getter(Gnss::assistAltitude)).setter(Gnss.setter(Builder::assistAltitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssistAltitude").build()}).build();
    private static final SdkField<Boolean> USE2_D_SOLVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Use2DSolver").getter(Gnss.getter(Gnss::use2DSolver)).setter(Gnss.setter(Builder::use2DSolver)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Use2DSolver").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_FIELD, CAPTURE_TIME_FIELD, CAPTURE_TIME_ACCURACY_FIELD, ASSIST_POSITION_FIELD, ASSIST_ALTITUDE_FIELD, USE2_D_SOLVER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String payload;
    private final Float captureTime;
    private final Float captureTimeAccuracy;
    private final List<Float> assistPosition;
    private final Float assistAltitude;
    private final Boolean use2DSolver;

    private Gnss(BuilderImpl builder) {
        this.payload = builder.payload;
        this.captureTime = builder.captureTime;
        this.captureTimeAccuracy = builder.captureTimeAccuracy;
        this.assistPosition = builder.assistPosition;
        this.assistAltitude = builder.assistAltitude;
        this.use2DSolver = builder.use2DSolver;
    }

    public final String payload() {
        return this.payload;
    }

    public final Float captureTime() {
        return this.captureTime;
    }

    public final Float captureTimeAccuracy() {
        return this.captureTimeAccuracy;
    }

    public final boolean hasAssistPosition() {
        return this.assistPosition != null && !(this.assistPosition instanceof SdkAutoConstructList);
    }

    public final List<Float> assistPosition() {
        return this.assistPosition;
    }

    public final Float assistAltitude() {
        return this.assistAltitude;
    }

    public final Boolean use2DSolver() {
        return this.use2DSolver;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.captureTimeAccuracy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssistPosition() ? this.assistPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assistAltitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.use2DSolver());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gnss)) {
            return false;
        }
        Gnss other = (Gnss)obj;
        return Objects.equals(this.payload(), other.payload()) && Objects.equals(this.captureTime(), other.captureTime()) && Objects.equals(this.captureTimeAccuracy(), other.captureTimeAccuracy()) && this.hasAssistPosition() == other.hasAssistPosition() && Objects.equals(this.assistPosition(), other.assistPosition()) && Objects.equals(this.assistAltitude(), other.assistAltitude()) && Objects.equals(this.use2DSolver(), other.use2DSolver());
    }

    public final String toString() {
        return ToString.builder((String)"Gnss").add("Payload", (Object)this.payload()).add("CaptureTime", (Object)this.captureTime()).add("CaptureTimeAccuracy", (Object)this.captureTimeAccuracy()).add("AssistPosition", this.hasAssistPosition() ? this.assistPosition() : null).add("AssistAltitude", (Object)this.assistAltitude()).add("Use2DSolver", (Object)this.use2DSolver()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "CaptureTime": {
                return Optional.ofNullable(clazz.cast(this.captureTime()));
            }
            case "CaptureTimeAccuracy": {
                return Optional.ofNullable(clazz.cast(this.captureTimeAccuracy()));
            }
            case "AssistPosition": {
                return Optional.ofNullable(clazz.cast(this.assistPosition()));
            }
            case "AssistAltitude": {
                return Optional.ofNullable(clazz.cast(this.assistAltitude()));
            }
            case "Use2DSolver": {
                return Optional.ofNullable(clazz.cast(this.use2DSolver()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Gnss, T> g) {
        return obj -> g.apply((Gnss)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String payload;
        private Float captureTime;
        private Float captureTimeAccuracy;
        private List<Float> assistPosition = DefaultSdkAutoConstructList.getInstance();
        private Float assistAltitude;
        private Boolean use2DSolver;

        private BuilderImpl() {
        }

        private BuilderImpl(Gnss model) {
            this.payload(model.payload);
            this.captureTime(model.captureTime);
            this.captureTimeAccuracy(model.captureTimeAccuracy);
            this.assistPosition(model.assistPosition);
            this.assistAltitude(model.assistAltitude);
            this.use2DSolver(model.use2DSolver);
        }

        public final String getPayload() {
            return this.payload;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public final Float getCaptureTime() {
            return this.captureTime;
        }

        public final void setCaptureTime(Float captureTime) {
            this.captureTime = captureTime;
        }

        @Override
        public final Builder captureTime(Float captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final Float getCaptureTimeAccuracy() {
            return this.captureTimeAccuracy;
        }

        public final void setCaptureTimeAccuracy(Float captureTimeAccuracy) {
            this.captureTimeAccuracy = captureTimeAccuracy;
        }

        @Override
        public final Builder captureTimeAccuracy(Float captureTimeAccuracy) {
            this.captureTimeAccuracy = captureTimeAccuracy;
            return this;
        }

        public final Collection<Float> getAssistPosition() {
            if (this.assistPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assistPosition;
        }

        public final void setAssistPosition(Collection<Float> assistPosition) {
            this.assistPosition = AssistPositionCopier.copy(assistPosition);
        }

        @Override
        public final Builder assistPosition(Collection<Float> assistPosition) {
            this.assistPosition = AssistPositionCopier.copy(assistPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assistPosition(Float ... assistPosition) {
            this.assistPosition(Arrays.asList(assistPosition));
            return this;
        }

        public final Float getAssistAltitude() {
            return this.assistAltitude;
        }

        public final void setAssistAltitude(Float assistAltitude) {
            this.assistAltitude = assistAltitude;
        }

        @Override
        public final Builder assistAltitude(Float assistAltitude) {
            this.assistAltitude = assistAltitude;
            return this;
        }

        public final Boolean getUse2DSolver() {
            return this.use2DSolver;
        }

        public final void setUse2DSolver(Boolean use2DSolver) {
            this.use2DSolver = use2DSolver;
        }

        @Override
        public final Builder use2DSolver(Boolean use2DSolver) {
            this.use2DSolver = use2DSolver;
            return this;
        }

        public Gnss build() {
            return new Gnss(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Gnss> {
        public Builder payload(String var1);

        public Builder captureTime(Float var1);

        public Builder captureTimeAccuracy(Float var1);

        public Builder assistPosition(Collection<Float> var1);

        public Builder assistPosition(Float ... var1);

        public Builder assistAltitude(Float var1);

        public Builder use2DSolver(Boolean var1);
    }
}

