/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWirelessGatewayTaskDefinitionResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetWirelessGatewayTaskDefinitionResponse.Builder, GetWirelessGatewayTaskDefinitionResponse> {
    private static final SdkField<Boolean> AUTO_CREATE_TASKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoCreateTasks").getter(getter(GetWirelessGatewayTaskDefinitionResponse::autoCreateTasks))
            .setter(setter(Builder::autoCreateTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCreateTasks").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetWirelessGatewayTaskDefinitionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<UpdateWirelessGatewayTaskCreate> UPDATE_FIELD = SdkField
            .<UpdateWirelessGatewayTaskCreate> builder(MarshallingType.SDK_POJO).memberName("Update")
            .getter(getter(GetWirelessGatewayTaskDefinitionResponse::update)).setter(setter(Builder::update))
            .constructor(UpdateWirelessGatewayTaskCreate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Update").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetWirelessGatewayTaskDefinitionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_CREATE_TASKS_FIELD,
            NAME_FIELD, UPDATE_FIELD, ARN_FIELD));

    private final Boolean autoCreateTasks;

    private final String name;

    private final UpdateWirelessGatewayTaskCreate update;

    private final String arn;

    private GetWirelessGatewayTaskDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.autoCreateTasks = builder.autoCreateTasks;
        this.name = builder.name;
        this.update = builder.update;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * Whether to automatically create tasks using this task definition for all gateways with the specified current
     * version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.
     * </p>
     * 
     * @return Whether to automatically create tasks using this task definition for all gateways with the specified
     *         current version. If <code>false</code>, the task must me created by calling
     *         <code>CreateWirelessGatewayTask</code>.
     */
    public final Boolean autoCreateTasks() {
        return autoCreateTasks;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Information about the gateways to update.
     * </p>
     * 
     * @return Information about the gateways to update.
     */
    public final UpdateWirelessGatewayTaskCreate update() {
        return update;
    }

    /**
     * <p>
     * The Amazon Resource Name of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name of the resource.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoCreateTasks());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(update());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessGatewayTaskDefinitionResponse)) {
            return false;
        }
        GetWirelessGatewayTaskDefinitionResponse other = (GetWirelessGatewayTaskDefinitionResponse) obj;
        return Objects.equals(autoCreateTasks(), other.autoCreateTasks()) && Objects.equals(name(), other.name())
                && Objects.equals(update(), other.update()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWirelessGatewayTaskDefinitionResponse").add("AutoCreateTasks", autoCreateTasks())
                .add("Name", name()).add("Update", update()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoCreateTasks":
            return Optional.ofNullable(clazz.cast(autoCreateTasks()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Update":
            return Optional.ofNullable(clazz.cast(update()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessGatewayTaskDefinitionResponse, T> g) {
        return obj -> g.apply((GetWirelessGatewayTaskDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWirelessGatewayTaskDefinitionResponse> {
        /**
         * <p>
         * Whether to automatically create tasks using this task definition for all gateways with the specified current
         * version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.
         * </p>
         * 
         * @param autoCreateTasks
         *        Whether to automatically create tasks using this task definition for all gateways with the specified
         *        current version. If <code>false</code>, the task must me created by calling
         *        <code>CreateWirelessGatewayTask</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoCreateTasks(Boolean autoCreateTasks);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the gateways to update.
         * </p>
         * 
         * @param update
         *        Information about the gateways to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder update(UpdateWirelessGatewayTaskCreate update);

        /**
         * <p>
         * Information about the gateways to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateWirelessGatewayTaskCreate.Builder}
         * avoiding the need to create one manually via {@link UpdateWirelessGatewayTaskCreate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateWirelessGatewayTaskCreate.Builder#build()} is called
         * immediately and its result is passed to {@link #update(UpdateWirelessGatewayTaskCreate)}.
         * 
         * @param update
         *        a consumer that will call methods on {@link UpdateWirelessGatewayTaskCreate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #update(UpdateWirelessGatewayTaskCreate)
         */
        default Builder update(Consumer<UpdateWirelessGatewayTaskCreate.Builder> update) {
            return update(UpdateWirelessGatewayTaskCreate.builder().applyMutation(update).build());
        }

        /**
         * <p>
         * The Amazon Resource Name of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private Boolean autoCreateTasks;

        private String name;

        private UpdateWirelessGatewayTaskCreate update;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessGatewayTaskDefinitionResponse model) {
            super(model);
            autoCreateTasks(model.autoCreateTasks);
            name(model.name);
            update(model.update);
            arn(model.arn);
        }

        public final Boolean getAutoCreateTasks() {
            return autoCreateTasks;
        }

        public final void setAutoCreateTasks(Boolean autoCreateTasks) {
            this.autoCreateTasks = autoCreateTasks;
        }

        @Override
        public final Builder autoCreateTasks(Boolean autoCreateTasks) {
            this.autoCreateTasks = autoCreateTasks;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final UpdateWirelessGatewayTaskCreate.Builder getUpdate() {
            return update != null ? update.toBuilder() : null;
        }

        public final void setUpdate(UpdateWirelessGatewayTaskCreate.BuilderImpl update) {
            this.update = update != null ? update.build() : null;
        }

        @Override
        public final Builder update(UpdateWirelessGatewayTaskCreate update) {
            this.update = update;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public GetWirelessGatewayTaskDefinitionResponse build() {
            return new GetWirelessGatewayTaskDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
