/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice;
import software.amazon.awssdk.services.iotwireless.model.PositioningConfigStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWirelessDeviceRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, UpdateWirelessDeviceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateWirelessDeviceRequest.getter(UpdateWirelessDeviceRequest::id)).setter(UpdateWirelessDeviceRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(UpdateWirelessDeviceRequest.getter(UpdateWirelessDeviceRequest::destinationName)).setter(UpdateWirelessDeviceRequest.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateWirelessDeviceRequest.getter(UpdateWirelessDeviceRequest::name)).setter(UpdateWirelessDeviceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateWirelessDeviceRequest.getter(UpdateWirelessDeviceRequest::description)).setter(UpdateWirelessDeviceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<LoRaWANUpdateDevice> LO_RA_WAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoRaWAN").getter(UpdateWirelessDeviceRequest.getter(UpdateWirelessDeviceRequest::loRaWAN)).setter(UpdateWirelessDeviceRequest.setter(Builder::loRaWAN)).constructor(LoRaWANUpdateDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()}).build();
    private static final SdkField<String> POSITIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Positioning").getter(UpdateWirelessDeviceRequest.getter(UpdateWirelessDeviceRequest::positioningAsString)).setter(UpdateWirelessDeviceRequest.setter(Builder::positioning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESTINATION_NAME_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LO_RA_WAN_FIELD, POSITIONING_FIELD));
    private final String id;
    private final String destinationName;
    private final String name;
    private final String description;
    private final LoRaWANUpdateDevice loRaWAN;
    private final String positioning;

    private UpdateWirelessDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.destinationName = builder.destinationName;
        this.name = builder.name;
        this.description = builder.description;
        this.loRaWAN = builder.loRaWAN;
        this.positioning = builder.positioning;
    }

    public final String id() {
        return this.id;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final LoRaWANUpdateDevice loRaWAN() {
        return this.loRaWAN;
    }

    public final PositioningConfigStatus positioning() {
        return PositioningConfigStatus.fromValue(this.positioning);
    }

    public final String positioningAsString() {
        return this.positioning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(this.positioningAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWirelessDeviceRequest)) {
            return false;
        }
        UpdateWirelessDeviceRequest other = (UpdateWirelessDeviceRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.loRaWAN(), other.loRaWAN()) && Objects.equals(this.positioningAsString(), other.positioningAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWirelessDeviceRequest").add("Id", (Object)this.id()).add("DestinationName", (Object)this.destinationName()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LoRaWAN", (Object)this.loRaWAN()).add("Positioning", (Object)this.positioningAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LoRaWAN": {
                return Optional.ofNullable(clazz.cast(this.loRaWAN()));
            }
            case "Positioning": {
                return Optional.ofNullable(clazz.cast(this.positioningAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWirelessDeviceRequest, T> g) {
        return obj -> g.apply((UpdateWirelessDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String id;
        private String destinationName;
        private String name;
        private String description;
        private LoRaWANUpdateDevice loRaWAN;
        private String positioning;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWirelessDeviceRequest model) {
            super(model);
            this.id(model.id);
            this.destinationName(model.destinationName);
            this.name(model.name);
            this.description(model.description);
            this.loRaWAN(model.loRaWAN);
            this.positioning(model.positioning);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final LoRaWANUpdateDevice.Builder getLoRaWAN() {
            return this.loRaWAN != null ? this.loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANUpdateDevice.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANUpdateDevice loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getPositioning() {
            return this.positioning;
        }

        public final void setPositioning(String positioning) {
            this.positioning = positioning;
        }

        @Override
        public final Builder positioning(String positioning) {
            this.positioning = positioning;
            return this;
        }

        @Override
        public final Builder positioning(PositioningConfigStatus positioning) {
            this.positioning(positioning == null ? null : positioning.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWirelessDeviceRequest build() {
            return new UpdateWirelessDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWirelessDeviceRequest> {
        public Builder id(String var1);

        public Builder destinationName(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder loRaWAN(LoRaWANUpdateDevice var1);

        default public Builder loRaWAN(Consumer<LoRaWANUpdateDevice.Builder> loRaWAN) {
            return this.loRaWAN((LoRaWANUpdateDevice)((LoRaWANUpdateDevice.Builder)LoRaWANUpdateDevice.builder().applyMutation(loRaWAN)).build());
        }

        public Builder positioning(String var1);

        public Builder positioning(PositioningConfigStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

