/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse;

public class ListQueuedMessagesIterable
implements SdkIterable<ListQueuedMessagesResponse> {
    private final IotWirelessClient client;
    private final ListQueuedMessagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueuedMessagesIterable(IotWirelessClient client, ListQueuedMessagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListQueuedMessagesResponseFetcher();
    }

    public Iterator<ListQueuedMessagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListQueuedMessagesResponseFetcher
    implements SyncPageFetcher<ListQueuedMessagesResponse> {
        private ListQueuedMessagesResponseFetcher() {
        }

        public boolean hasNextPage(ListQueuedMessagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueuedMessagesResponse nextPage(ListQueuedMessagesResponse previousPage) {
            if (previousPage == null) {
                return ListQueuedMessagesIterable.this.client.listQueuedMessages(ListQueuedMessagesIterable.this.firstRequest);
            }
            return ListQueuedMessagesIterable.this.client.listQueuedMessages((ListQueuedMessagesRequest)((Object)ListQueuedMessagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

