/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotwireless.DefaultIotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.DefaultIotWirelessBaseClientBuilder;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClientBuilder;
import software.amazon.awssdk.services.iotwireless.IotWirelessServiceClientConfiguration;
import software.amazon.awssdk.services.iotwireless.endpoints.IotWirelessEndpointProvider;

@SdkInternalApi
final class DefaultIotWirelessAsyncClientBuilder
extends DefaultIotWirelessBaseClientBuilder<IotWirelessAsyncClientBuilder, IotWirelessAsyncClient>
implements IotWirelessAsyncClientBuilder {
    DefaultIotWirelessAsyncClientBuilder() {
    }

    @Override
    public DefaultIotWirelessAsyncClientBuilder endpointProvider(IotWirelessEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotWirelessAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIotWirelessAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IotWirelessServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotWirelessAsyncClient client = new DefaultIotWirelessAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotWirelessServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotWirelessServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

