/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WiFiAccessPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WiFiAccessPoint> {
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAddress").getter(WiFiAccessPoint.getter(WiFiAccessPoint::macAddress)).setter(WiFiAccessPoint.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").build()}).build();
    private static final SdkField<Integer> RSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Rss").getter(WiFiAccessPoint.getter(WiFiAccessPoint::rss)).setter(WiFiAccessPoint.setter(Builder::rss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rss").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAC_ADDRESS_FIELD, RSS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String macAddress;
    private final Integer rss;

    private WiFiAccessPoint(BuilderImpl builder) {
        this.macAddress = builder.macAddress;
        this.rss = builder.rss;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final Integer rss() {
        return this.rss;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.rss());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WiFiAccessPoint)) {
            return false;
        }
        WiFiAccessPoint other = (WiFiAccessPoint)obj;
        return Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.rss(), other.rss());
    }

    public final String toString() {
        return ToString.builder((String)"WiFiAccessPoint").add("MacAddress", (Object)this.macAddress()).add("Rss", (Object)this.rss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "Rss": {
                return Optional.ofNullable(clazz.cast(this.rss()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WiFiAccessPoint, T> g) {
        return obj -> g.apply((WiFiAccessPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String macAddress;
        private Integer rss;

        private BuilderImpl() {
        }

        private BuilderImpl(WiFiAccessPoint model) {
            this.macAddress(model.macAddress);
            this.rss(model.rss);
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final Integer getRss() {
            return this.rss;
        }

        public final void setRss(Integer rss) {
            this.rss = rss;
        }

        @Override
        public final Builder rss(Integer rss) {
            this.rss = rss;
            return this;
        }

        public WiFiAccessPoint build() {
            return new WiFiAccessPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WiFiAccessPoint> {
        public Builder macAddress(String var1);

        public Builder rss(Integer var1);
    }
}

