/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SupportedRfRegion {
    EU868("EU868"),
    US915("US915"),
    AU915("AU915"),
    AS923_1("AS923-1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SupportedRfRegion> VALUE_MAP;
    private final String value;

    private SupportedRfRegion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SupportedRfRegion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SupportedRfRegion> knownValues() {
        EnumSet<SupportedRfRegion> knownValues = EnumSet.allOf(SupportedRfRegion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SupportedRfRegion.class, SupportedRfRegion::toString);
    }
}

