/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest;
import software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse;

public class ListFuotaTasksPublisher
implements SdkPublisher<ListFuotaTasksResponse> {
    private final IotWirelessAsyncClient client;
    private final ListFuotaTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFuotaTasksPublisher(IotWirelessAsyncClient client, ListFuotaTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFuotaTasksPublisher(IotWirelessAsyncClient client, ListFuotaTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFuotaTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFuotaTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFuotaTasksResponseFetcher
    implements AsyncPageFetcher<ListFuotaTasksResponse> {
        private ListFuotaTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListFuotaTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFuotaTasksResponse> nextPage(ListFuotaTasksResponse previousPage) {
            if (previousPage == null) {
                return ListFuotaTasksPublisher.this.client.listFuotaTasks(ListFuotaTasksPublisher.this.firstRequest);
            }
            return ListFuotaTasksPublisher.this.client.listFuotaTasks((ListFuotaTasksRequest)((Object)ListFuotaTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

