/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.FactoryPresetFreqsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANDeviceProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANDeviceProfile> {
    private static final SdkField<Boolean> SUPPORTS_CLASSB_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsClassB").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::supportsClassB)).setter(LoRaWANDeviceProfile.setter(Builder::supportsClassB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsClassB").build()}).build();
    private static final SdkField<Integer> CLASS_B_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ClassBTimeout").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::classBTimeout)).setter(LoRaWANDeviceProfile.setter(Builder::classBTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassBTimeout").build()}).build();
    private static final SdkField<Integer> PING_SLOT_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PingSlotPeriod").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::pingSlotPeriod)).setter(LoRaWANDeviceProfile.setter(Builder::pingSlotPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingSlotPeriod").build()}).build();
    private static final SdkField<Integer> PING_SLOT_DR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PingSlotDr").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::pingSlotDr)).setter(LoRaWANDeviceProfile.setter(Builder::pingSlotDr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingSlotDr").build()}).build();
    private static final SdkField<Integer> PING_SLOT_FREQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PingSlotFreq").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::pingSlotFreq)).setter(LoRaWANDeviceProfile.setter(Builder::pingSlotFreq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingSlotFreq").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_CLASSC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsClassC").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::supportsClassC)).setter(LoRaWANDeviceProfile.setter(Builder::supportsClassC)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsClassC").build()}).build();
    private static final SdkField<Integer> CLASS_C_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ClassCTimeout").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::classCTimeout)).setter(LoRaWANDeviceProfile.setter(Builder::classCTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassCTimeout").build()}).build();
    private static final SdkField<String> MAC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacVersion").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::macVersion)).setter(LoRaWANDeviceProfile.setter(Builder::macVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacVersion").build()}).build();
    private static final SdkField<String> REG_PARAMS_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegParamsRevision").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::regParamsRevision)).setter(LoRaWANDeviceProfile.setter(Builder::regParamsRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegParamsRevision").build()}).build();
    private static final SdkField<Integer> RX_DELAY1_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RxDelay1").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::rxDelay1)).setter(LoRaWANDeviceProfile.setter(Builder::rxDelay1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxDelay1").build()}).build();
    private static final SdkField<Integer> RX_DR_OFFSET1_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RxDrOffset1").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::rxDrOffset1)).setter(LoRaWANDeviceProfile.setter(Builder::rxDrOffset1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxDrOffset1").build()}).build();
    private static final SdkField<Integer> RX_DATA_RATE2_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RxDataRate2").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::rxDataRate2)).setter(LoRaWANDeviceProfile.setter(Builder::rxDataRate2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxDataRate2").build()}).build();
    private static final SdkField<Integer> RX_FREQ2_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RxFreq2").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::rxFreq2)).setter(LoRaWANDeviceProfile.setter(Builder::rxFreq2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxFreq2").build()}).build();
    private static final SdkField<List<Integer>> FACTORY_PRESET_FREQS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FactoryPresetFreqsList").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::factoryPresetFreqsList)).setter(LoRaWANDeviceProfile.setter(Builder::factoryPresetFreqsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FactoryPresetFreqsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_EIRP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxEirp").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::maxEirp)).setter(LoRaWANDeviceProfile.setter(Builder::maxEirp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEirp").build()}).build();
    private static final SdkField<Integer> MAX_DUTY_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxDutyCycle").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::maxDutyCycle)).setter(LoRaWANDeviceProfile.setter(Builder::maxDutyCycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDutyCycle").build()}).build();
    private static final SdkField<String> RF_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RfRegion").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::rfRegion)).setter(LoRaWANDeviceProfile.setter(Builder::rfRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RfRegion").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_JOIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsJoin").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::supportsJoin)).setter(LoRaWANDeviceProfile.setter(Builder::supportsJoin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsJoin").build()}).build();
    private static final SdkField<Boolean> SUPPORTS32_BIT_F_CNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Supports32BitFCnt").getter(LoRaWANDeviceProfile.getter(LoRaWANDeviceProfile::supports32BitFCnt)).setter(LoRaWANDeviceProfile.setter(Builder::supports32BitFCnt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Supports32BitFCnt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTS_CLASSB_FIELD, CLASS_B_TIMEOUT_FIELD, PING_SLOT_PERIOD_FIELD, PING_SLOT_DR_FIELD, PING_SLOT_FREQ_FIELD, SUPPORTS_CLASSC_FIELD, CLASS_C_TIMEOUT_FIELD, MAC_VERSION_FIELD, REG_PARAMS_REVISION_FIELD, RX_DELAY1_FIELD, RX_DR_OFFSET1_FIELD, RX_DATA_RATE2_FIELD, RX_FREQ2_FIELD, FACTORY_PRESET_FREQS_LIST_FIELD, MAX_EIRP_FIELD, MAX_DUTY_CYCLE_FIELD, RF_REGION_FIELD, SUPPORTS_JOIN_FIELD, SUPPORTS32_BIT_F_CNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean supportsClassB;
    private final Integer classBTimeout;
    private final Integer pingSlotPeriod;
    private final Integer pingSlotDr;
    private final Integer pingSlotFreq;
    private final Boolean supportsClassC;
    private final Integer classCTimeout;
    private final String macVersion;
    private final String regParamsRevision;
    private final Integer rxDelay1;
    private final Integer rxDrOffset1;
    private final Integer rxDataRate2;
    private final Integer rxFreq2;
    private final List<Integer> factoryPresetFreqsList;
    private final Integer maxEirp;
    private final Integer maxDutyCycle;
    private final String rfRegion;
    private final Boolean supportsJoin;
    private final Boolean supports32BitFCnt;

    private LoRaWANDeviceProfile(BuilderImpl builder) {
        this.supportsClassB = builder.supportsClassB;
        this.classBTimeout = builder.classBTimeout;
        this.pingSlotPeriod = builder.pingSlotPeriod;
        this.pingSlotDr = builder.pingSlotDr;
        this.pingSlotFreq = builder.pingSlotFreq;
        this.supportsClassC = builder.supportsClassC;
        this.classCTimeout = builder.classCTimeout;
        this.macVersion = builder.macVersion;
        this.regParamsRevision = builder.regParamsRevision;
        this.rxDelay1 = builder.rxDelay1;
        this.rxDrOffset1 = builder.rxDrOffset1;
        this.rxDataRate2 = builder.rxDataRate2;
        this.rxFreq2 = builder.rxFreq2;
        this.factoryPresetFreqsList = builder.factoryPresetFreqsList;
        this.maxEirp = builder.maxEirp;
        this.maxDutyCycle = builder.maxDutyCycle;
        this.rfRegion = builder.rfRegion;
        this.supportsJoin = builder.supportsJoin;
        this.supports32BitFCnt = builder.supports32BitFCnt;
    }

    public final Boolean supportsClassB() {
        return this.supportsClassB;
    }

    public final Integer classBTimeout() {
        return this.classBTimeout;
    }

    public final Integer pingSlotPeriod() {
        return this.pingSlotPeriod;
    }

    public final Integer pingSlotDr() {
        return this.pingSlotDr;
    }

    public final Integer pingSlotFreq() {
        return this.pingSlotFreq;
    }

    public final Boolean supportsClassC() {
        return this.supportsClassC;
    }

    public final Integer classCTimeout() {
        return this.classCTimeout;
    }

    public final String macVersion() {
        return this.macVersion;
    }

    public final String regParamsRevision() {
        return this.regParamsRevision;
    }

    public final Integer rxDelay1() {
        return this.rxDelay1;
    }

    public final Integer rxDrOffset1() {
        return this.rxDrOffset1;
    }

    public final Integer rxDataRate2() {
        return this.rxDataRate2;
    }

    public final Integer rxFreq2() {
        return this.rxFreq2;
    }

    public final boolean hasFactoryPresetFreqsList() {
        return this.factoryPresetFreqsList != null && !(this.factoryPresetFreqsList instanceof SdkAutoConstructList);
    }

    public final List<Integer> factoryPresetFreqsList() {
        return this.factoryPresetFreqsList;
    }

    public final Integer maxEirp() {
        return this.maxEirp;
    }

    public final Integer maxDutyCycle() {
        return this.maxDutyCycle;
    }

    public final String rfRegion() {
        return this.rfRegion;
    }

    public final Boolean supportsJoin() {
        return this.supportsJoin;
    }

    public final Boolean supports32BitFCnt() {
        return this.supports32BitFCnt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsClassB());
        hashCode = 31 * hashCode + Objects.hashCode(this.classBTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.pingSlotPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.pingSlotDr());
        hashCode = 31 * hashCode + Objects.hashCode(this.pingSlotFreq());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsClassC());
        hashCode = 31 * hashCode + Objects.hashCode(this.classCTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.macVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.regParamsRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.rxDelay1());
        hashCode = 31 * hashCode + Objects.hashCode(this.rxDrOffset1());
        hashCode = 31 * hashCode + Objects.hashCode(this.rxDataRate2());
        hashCode = 31 * hashCode + Objects.hashCode(this.rxFreq2());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFactoryPresetFreqsList() ? this.factoryPresetFreqsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxEirp());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDutyCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.rfRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsJoin());
        hashCode = 31 * hashCode + Objects.hashCode(this.supports32BitFCnt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANDeviceProfile)) {
            return false;
        }
        LoRaWANDeviceProfile other = (LoRaWANDeviceProfile)obj;
        return Objects.equals(this.supportsClassB(), other.supportsClassB()) && Objects.equals(this.classBTimeout(), other.classBTimeout()) && Objects.equals(this.pingSlotPeriod(), other.pingSlotPeriod()) && Objects.equals(this.pingSlotDr(), other.pingSlotDr()) && Objects.equals(this.pingSlotFreq(), other.pingSlotFreq()) && Objects.equals(this.supportsClassC(), other.supportsClassC()) && Objects.equals(this.classCTimeout(), other.classCTimeout()) && Objects.equals(this.macVersion(), other.macVersion()) && Objects.equals(this.regParamsRevision(), other.regParamsRevision()) && Objects.equals(this.rxDelay1(), other.rxDelay1()) && Objects.equals(this.rxDrOffset1(), other.rxDrOffset1()) && Objects.equals(this.rxDataRate2(), other.rxDataRate2()) && Objects.equals(this.rxFreq2(), other.rxFreq2()) && this.hasFactoryPresetFreqsList() == other.hasFactoryPresetFreqsList() && Objects.equals(this.factoryPresetFreqsList(), other.factoryPresetFreqsList()) && Objects.equals(this.maxEirp(), other.maxEirp()) && Objects.equals(this.maxDutyCycle(), other.maxDutyCycle()) && Objects.equals(this.rfRegion(), other.rfRegion()) && Objects.equals(this.supportsJoin(), other.supportsJoin()) && Objects.equals(this.supports32BitFCnt(), other.supports32BitFCnt());
    }

    public final String toString() {
        return ToString.builder((String)"LoRaWANDeviceProfile").add("SupportsClassB", (Object)this.supportsClassB()).add("ClassBTimeout", (Object)this.classBTimeout()).add("PingSlotPeriod", (Object)this.pingSlotPeriod()).add("PingSlotDr", (Object)this.pingSlotDr()).add("PingSlotFreq", (Object)this.pingSlotFreq()).add("SupportsClassC", (Object)this.supportsClassC()).add("ClassCTimeout", (Object)this.classCTimeout()).add("MacVersion", (Object)this.macVersion()).add("RegParamsRevision", (Object)this.regParamsRevision()).add("RxDelay1", (Object)this.rxDelay1()).add("RxDrOffset1", (Object)this.rxDrOffset1()).add("RxDataRate2", (Object)this.rxDataRate2()).add("RxFreq2", (Object)this.rxFreq2()).add("FactoryPresetFreqsList", this.hasFactoryPresetFreqsList() ? this.factoryPresetFreqsList() : null).add("MaxEirp", (Object)this.maxEirp()).add("MaxDutyCycle", (Object)this.maxDutyCycle()).add("RfRegion", (Object)this.rfRegion()).add("SupportsJoin", (Object)this.supportsJoin()).add("Supports32BitFCnt", (Object)this.supports32BitFCnt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SupportsClassB": {
                return Optional.ofNullable(clazz.cast(this.supportsClassB()));
            }
            case "ClassBTimeout": {
                return Optional.ofNullable(clazz.cast(this.classBTimeout()));
            }
            case "PingSlotPeriod": {
                return Optional.ofNullable(clazz.cast(this.pingSlotPeriod()));
            }
            case "PingSlotDr": {
                return Optional.ofNullable(clazz.cast(this.pingSlotDr()));
            }
            case "PingSlotFreq": {
                return Optional.ofNullable(clazz.cast(this.pingSlotFreq()));
            }
            case "SupportsClassC": {
                return Optional.ofNullable(clazz.cast(this.supportsClassC()));
            }
            case "ClassCTimeout": {
                return Optional.ofNullable(clazz.cast(this.classCTimeout()));
            }
            case "MacVersion": {
                return Optional.ofNullable(clazz.cast(this.macVersion()));
            }
            case "RegParamsRevision": {
                return Optional.ofNullable(clazz.cast(this.regParamsRevision()));
            }
            case "RxDelay1": {
                return Optional.ofNullable(clazz.cast(this.rxDelay1()));
            }
            case "RxDrOffset1": {
                return Optional.ofNullable(clazz.cast(this.rxDrOffset1()));
            }
            case "RxDataRate2": {
                return Optional.ofNullable(clazz.cast(this.rxDataRate2()));
            }
            case "RxFreq2": {
                return Optional.ofNullable(clazz.cast(this.rxFreq2()));
            }
            case "FactoryPresetFreqsList": {
                return Optional.ofNullable(clazz.cast(this.factoryPresetFreqsList()));
            }
            case "MaxEirp": {
                return Optional.ofNullable(clazz.cast(this.maxEirp()));
            }
            case "MaxDutyCycle": {
                return Optional.ofNullable(clazz.cast(this.maxDutyCycle()));
            }
            case "RfRegion": {
                return Optional.ofNullable(clazz.cast(this.rfRegion()));
            }
            case "SupportsJoin": {
                return Optional.ofNullable(clazz.cast(this.supportsJoin()));
            }
            case "Supports32BitFCnt": {
                return Optional.ofNullable(clazz.cast(this.supports32BitFCnt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANDeviceProfile, T> g) {
        return obj -> g.apply((LoRaWANDeviceProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean supportsClassB;
        private Integer classBTimeout;
        private Integer pingSlotPeriod;
        private Integer pingSlotDr;
        private Integer pingSlotFreq;
        private Boolean supportsClassC;
        private Integer classCTimeout;
        private String macVersion;
        private String regParamsRevision;
        private Integer rxDelay1;
        private Integer rxDrOffset1;
        private Integer rxDataRate2;
        private Integer rxFreq2;
        private List<Integer> factoryPresetFreqsList = DefaultSdkAutoConstructList.getInstance();
        private Integer maxEirp;
        private Integer maxDutyCycle;
        private String rfRegion;
        private Boolean supportsJoin;
        private Boolean supports32BitFCnt;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANDeviceProfile model) {
            this.supportsClassB(model.supportsClassB);
            this.classBTimeout(model.classBTimeout);
            this.pingSlotPeriod(model.pingSlotPeriod);
            this.pingSlotDr(model.pingSlotDr);
            this.pingSlotFreq(model.pingSlotFreq);
            this.supportsClassC(model.supportsClassC);
            this.classCTimeout(model.classCTimeout);
            this.macVersion(model.macVersion);
            this.regParamsRevision(model.regParamsRevision);
            this.rxDelay1(model.rxDelay1);
            this.rxDrOffset1(model.rxDrOffset1);
            this.rxDataRate2(model.rxDataRate2);
            this.rxFreq2(model.rxFreq2);
            this.factoryPresetFreqsList(model.factoryPresetFreqsList);
            this.maxEirp(model.maxEirp);
            this.maxDutyCycle(model.maxDutyCycle);
            this.rfRegion(model.rfRegion);
            this.supportsJoin(model.supportsJoin);
            this.supports32BitFCnt(model.supports32BitFCnt);
        }

        public final Boolean getSupportsClassB() {
            return this.supportsClassB;
        }

        public final void setSupportsClassB(Boolean supportsClassB) {
            this.supportsClassB = supportsClassB;
        }

        @Override
        public final Builder supportsClassB(Boolean supportsClassB) {
            this.supportsClassB = supportsClassB;
            return this;
        }

        public final Integer getClassBTimeout() {
            return this.classBTimeout;
        }

        public final void setClassBTimeout(Integer classBTimeout) {
            this.classBTimeout = classBTimeout;
        }

        @Override
        public final Builder classBTimeout(Integer classBTimeout) {
            this.classBTimeout = classBTimeout;
            return this;
        }

        public final Integer getPingSlotPeriod() {
            return this.pingSlotPeriod;
        }

        public final void setPingSlotPeriod(Integer pingSlotPeriod) {
            this.pingSlotPeriod = pingSlotPeriod;
        }

        @Override
        public final Builder pingSlotPeriod(Integer pingSlotPeriod) {
            this.pingSlotPeriod = pingSlotPeriod;
            return this;
        }

        public final Integer getPingSlotDr() {
            return this.pingSlotDr;
        }

        public final void setPingSlotDr(Integer pingSlotDr) {
            this.pingSlotDr = pingSlotDr;
        }

        @Override
        public final Builder pingSlotDr(Integer pingSlotDr) {
            this.pingSlotDr = pingSlotDr;
            return this;
        }

        public final Integer getPingSlotFreq() {
            return this.pingSlotFreq;
        }

        public final void setPingSlotFreq(Integer pingSlotFreq) {
            this.pingSlotFreq = pingSlotFreq;
        }

        @Override
        public final Builder pingSlotFreq(Integer pingSlotFreq) {
            this.pingSlotFreq = pingSlotFreq;
            return this;
        }

        public final Boolean getSupportsClassC() {
            return this.supportsClassC;
        }

        public final void setSupportsClassC(Boolean supportsClassC) {
            this.supportsClassC = supportsClassC;
        }

        @Override
        public final Builder supportsClassC(Boolean supportsClassC) {
            this.supportsClassC = supportsClassC;
            return this;
        }

        public final Integer getClassCTimeout() {
            return this.classCTimeout;
        }

        public final void setClassCTimeout(Integer classCTimeout) {
            this.classCTimeout = classCTimeout;
        }

        @Override
        public final Builder classCTimeout(Integer classCTimeout) {
            this.classCTimeout = classCTimeout;
            return this;
        }

        public final String getMacVersion() {
            return this.macVersion;
        }

        public final void setMacVersion(String macVersion) {
            this.macVersion = macVersion;
        }

        @Override
        public final Builder macVersion(String macVersion) {
            this.macVersion = macVersion;
            return this;
        }

        public final String getRegParamsRevision() {
            return this.regParamsRevision;
        }

        public final void setRegParamsRevision(String regParamsRevision) {
            this.regParamsRevision = regParamsRevision;
        }

        @Override
        public final Builder regParamsRevision(String regParamsRevision) {
            this.regParamsRevision = regParamsRevision;
            return this;
        }

        public final Integer getRxDelay1() {
            return this.rxDelay1;
        }

        public final void setRxDelay1(Integer rxDelay1) {
            this.rxDelay1 = rxDelay1;
        }

        @Override
        public final Builder rxDelay1(Integer rxDelay1) {
            this.rxDelay1 = rxDelay1;
            return this;
        }

        public final Integer getRxDrOffset1() {
            return this.rxDrOffset1;
        }

        public final void setRxDrOffset1(Integer rxDrOffset1) {
            this.rxDrOffset1 = rxDrOffset1;
        }

        @Override
        public final Builder rxDrOffset1(Integer rxDrOffset1) {
            this.rxDrOffset1 = rxDrOffset1;
            return this;
        }

        public final Integer getRxDataRate2() {
            return this.rxDataRate2;
        }

        public final void setRxDataRate2(Integer rxDataRate2) {
            this.rxDataRate2 = rxDataRate2;
        }

        @Override
        public final Builder rxDataRate2(Integer rxDataRate2) {
            this.rxDataRate2 = rxDataRate2;
            return this;
        }

        public final Integer getRxFreq2() {
            return this.rxFreq2;
        }

        public final void setRxFreq2(Integer rxFreq2) {
            this.rxFreq2 = rxFreq2;
        }

        @Override
        public final Builder rxFreq2(Integer rxFreq2) {
            this.rxFreq2 = rxFreq2;
            return this;
        }

        public final Collection<Integer> getFactoryPresetFreqsList() {
            if (this.factoryPresetFreqsList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.factoryPresetFreqsList;
        }

        public final void setFactoryPresetFreqsList(Collection<Integer> factoryPresetFreqsList) {
            this.factoryPresetFreqsList = FactoryPresetFreqsListCopier.copy(factoryPresetFreqsList);
        }

        @Override
        public final Builder factoryPresetFreqsList(Collection<Integer> factoryPresetFreqsList) {
            this.factoryPresetFreqsList = FactoryPresetFreqsListCopier.copy(factoryPresetFreqsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder factoryPresetFreqsList(Integer ... factoryPresetFreqsList) {
            this.factoryPresetFreqsList(Arrays.asList(factoryPresetFreqsList));
            return this;
        }

        public final Integer getMaxEirp() {
            return this.maxEirp;
        }

        public final void setMaxEirp(Integer maxEirp) {
            this.maxEirp = maxEirp;
        }

        @Override
        public final Builder maxEirp(Integer maxEirp) {
            this.maxEirp = maxEirp;
            return this;
        }

        public final Integer getMaxDutyCycle() {
            return this.maxDutyCycle;
        }

        public final void setMaxDutyCycle(Integer maxDutyCycle) {
            this.maxDutyCycle = maxDutyCycle;
        }

        @Override
        public final Builder maxDutyCycle(Integer maxDutyCycle) {
            this.maxDutyCycle = maxDutyCycle;
            return this;
        }

        public final String getRfRegion() {
            return this.rfRegion;
        }

        public final void setRfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
        }

        @Override
        public final Builder rfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
            return this;
        }

        public final Boolean getSupportsJoin() {
            return this.supportsJoin;
        }

        public final void setSupportsJoin(Boolean supportsJoin) {
            this.supportsJoin = supportsJoin;
        }

        @Override
        public final Builder supportsJoin(Boolean supportsJoin) {
            this.supportsJoin = supportsJoin;
            return this;
        }

        public final Boolean getSupports32BitFCnt() {
            return this.supports32BitFCnt;
        }

        public final void setSupports32BitFCnt(Boolean supports32BitFCnt) {
            this.supports32BitFCnt = supports32BitFCnt;
        }

        @Override
        public final Builder supports32BitFCnt(Boolean supports32BitFCnt) {
            this.supports32BitFCnt = supports32BitFCnt;
            return this;
        }

        public LoRaWANDeviceProfile build() {
            return new LoRaWANDeviceProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANDeviceProfile> {
        public Builder supportsClassB(Boolean var1);

        public Builder classBTimeout(Integer var1);

        public Builder pingSlotPeriod(Integer var1);

        public Builder pingSlotDr(Integer var1);

        public Builder pingSlotFreq(Integer var1);

        public Builder supportsClassC(Boolean var1);

        public Builder classCTimeout(Integer var1);

        public Builder macVersion(String var1);

        public Builder regParamsRevision(String var1);

        public Builder rxDelay1(Integer var1);

        public Builder rxDrOffset1(Integer var1);

        public Builder rxDataRate2(Integer var1);

        public Builder rxFreq2(Integer var1);

        public Builder factoryPresetFreqsList(Collection<Integer> var1);

        public Builder factoryPresetFreqsList(Integer ... var1);

        public Builder maxEirp(Integer var1);

        public Builder maxDutyCycle(Integer var1);

        public Builder rfRegion(String var1);

        public Builder supportsJoin(Boolean var1);

        public Builder supports32BitFCnt(Boolean var1);
    }
}

