/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateAwsAccountWithPartnerAccountResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, AssociateAwsAccountWithPartnerAccountResponse> {
    private static final SdkField<SidewalkAccountInfo> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(AssociateAwsAccountWithPartnerAccountResponse.getter(AssociateAwsAccountWithPartnerAccountResponse::sidewalk)).setter(AssociateAwsAccountWithPartnerAccountResponse.setter(Builder::sidewalk)).constructor(SidewalkAccountInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AssociateAwsAccountWithPartnerAccountResponse.getter(AssociateAwsAccountWithPartnerAccountResponse::arn)).setter(AssociateAwsAccountWithPartnerAccountResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIDEWALK_FIELD, ARN_FIELD));
    private final SidewalkAccountInfo sidewalk;
    private final String arn;

    private AssociateAwsAccountWithPartnerAccountResponse(BuilderImpl builder) {
        super(builder);
        this.sidewalk = builder.sidewalk;
        this.arn = builder.arn;
    }

    public final SidewalkAccountInfo sidewalk() {
        return this.sidewalk;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAwsAccountWithPartnerAccountResponse)) {
            return false;
        }
        AssociateAwsAccountWithPartnerAccountResponse other = (AssociateAwsAccountWithPartnerAccountResponse)((Object)obj);
        return Objects.equals(this.sidewalk(), other.sidewalk()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateAwsAccountWithPartnerAccountResponse").add("Sidewalk", (Object)this.sidewalk()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateAwsAccountWithPartnerAccountResponse, T> g) {
        return obj -> g.apply((AssociateAwsAccountWithPartnerAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private SidewalkAccountInfo sidewalk;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAwsAccountWithPartnerAccountResponse model) {
            super(model);
            this.sidewalk(model.sidewalk);
            this.arn(model.arn);
        }

        public final SidewalkAccountInfo.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkAccountInfo.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkAccountInfo sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public AssociateAwsAccountWithPartnerAccountResponse build() {
            return new AssociateAwsAccountWithPartnerAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateAwsAccountWithPartnerAccountResponse> {
        public Builder sidewalk(SidewalkAccountInfo var1);

        default public Builder sidewalk(Consumer<SidewalkAccountInfo.Builder> sidewalk) {
            return this.sidewalk((SidewalkAccountInfo)((SidewalkAccountInfo.Builder)SidewalkAccountInfo.builder().applyMutation(sidewalk)).build());
        }

        public Builder arn(String var1);
    }
}

