/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse;

public class ListDeviceProfilesPublisher
implements SdkPublisher<ListDeviceProfilesResponse> {
    private final IotWirelessAsyncClient client;
    private final ListDeviceProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeviceProfilesPublisher(IotWirelessAsyncClient client, ListDeviceProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeviceProfilesPublisher(IotWirelessAsyncClient client, ListDeviceProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeviceProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeviceProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDeviceProfilesResponseFetcher
    implements AsyncPageFetcher<ListDeviceProfilesResponse> {
        private ListDeviceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeviceProfilesResponse> nextPage(ListDeviceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceProfilesPublisher.this.client.listDeviceProfiles(ListDeviceProfilesPublisher.this.firstRequest);
            }
            return ListDeviceProfilesPublisher.this.client.listDeviceProfiles((ListDeviceProfilesRequest)((Object)ListDeviceProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

