/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum WirelessDeviceType {
    SIDEWALK("Sidewalk"),
    LO_RA_WAN("LoRaWAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private WirelessDeviceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WirelessDeviceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(WirelessDeviceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WirelessDeviceType> knownValues() {
        return Stream.of(WirelessDeviceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

