/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWirelessGatewayStatisticsResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetWirelessGatewayStatisticsResponse> {
    private static final SdkField<String> WIRELESS_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessGatewayId").getter(GetWirelessGatewayStatisticsResponse.getter(GetWirelessGatewayStatisticsResponse::wirelessGatewayId)).setter(GetWirelessGatewayStatisticsResponse.setter(Builder::wirelessGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayId").build()}).build();
    private static final SdkField<String> LAST_UPLINK_RECEIVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUplinkReceivedAt").getter(GetWirelessGatewayStatisticsResponse.getter(GetWirelessGatewayStatisticsResponse::lastUplinkReceivedAt)).setter(GetWirelessGatewayStatisticsResponse.setter(Builder::lastUplinkReceivedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUplinkReceivedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIRELESS_GATEWAY_ID_FIELD, LAST_UPLINK_RECEIVED_AT_FIELD));
    private final String wirelessGatewayId;
    private final String lastUplinkReceivedAt;

    private GetWirelessGatewayStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.wirelessGatewayId = builder.wirelessGatewayId;
        this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
    }

    public String wirelessGatewayId() {
        return this.wirelessGatewayId;
    }

    public String lastUplinkReceivedAt() {
        return this.lastUplinkReceivedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUplinkReceivedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessGatewayStatisticsResponse)) {
            return false;
        }
        GetWirelessGatewayStatisticsResponse other = (GetWirelessGatewayStatisticsResponse)((Object)obj);
        return Objects.equals(this.wirelessGatewayId(), other.wirelessGatewayId()) && Objects.equals(this.lastUplinkReceivedAt(), other.lastUplinkReceivedAt());
    }

    public String toString() {
        return ToString.builder((String)"GetWirelessGatewayStatisticsResponse").add("WirelessGatewayId", (Object)this.wirelessGatewayId()).add("LastUplinkReceivedAt", (Object)this.lastUplinkReceivedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WirelessGatewayId": {
                return Optional.ofNullable(clazz.cast(this.wirelessGatewayId()));
            }
            case "LastUplinkReceivedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUplinkReceivedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessGatewayStatisticsResponse, T> g) {
        return obj -> g.apply((GetWirelessGatewayStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String wirelessGatewayId;
        private String lastUplinkReceivedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessGatewayStatisticsResponse model) {
            super(model);
            this.wirelessGatewayId(model.wirelessGatewayId);
            this.lastUplinkReceivedAt(model.lastUplinkReceivedAt);
        }

        public final String getWirelessGatewayId() {
            return this.wirelessGatewayId;
        }

        @Override
        public final Builder wirelessGatewayId(String wirelessGatewayId) {
            this.wirelessGatewayId = wirelessGatewayId;
            return this;
        }

        public final void setWirelessGatewayId(String wirelessGatewayId) {
            this.wirelessGatewayId = wirelessGatewayId;
        }

        public final String getLastUplinkReceivedAt() {
            return this.lastUplinkReceivedAt;
        }

        @Override
        public final Builder lastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        public final void setLastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
        }

        @Override
        public GetWirelessGatewayStatisticsResponse build() {
            return new GetWirelessGatewayStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWirelessGatewayStatisticsResponse> {
        public Builder wirelessGatewayId(String var1);

        public Builder lastUplinkReceivedAt(String var1);
    }
}

