/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateAwsAccountWithPartnerAccountRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, AssociateAwsAccountWithPartnerAccountRequest> {
    private static final SdkField<SidewalkAccountInfo> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(AssociateAwsAccountWithPartnerAccountRequest.getter(AssociateAwsAccountWithPartnerAccountRequest::sidewalk)).setter(AssociateAwsAccountWithPartnerAccountRequest.setter(Builder::sidewalk)).constructor(SidewalkAccountInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(AssociateAwsAccountWithPartnerAccountRequest.getter(AssociateAwsAccountWithPartnerAccountRequest::clientRequestToken)).setter(AssociateAwsAccountWithPartnerAccountRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIDEWALK_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final SidewalkAccountInfo sidewalk;
    private final String clientRequestToken;

    private AssociateAwsAccountWithPartnerAccountRequest(BuilderImpl builder) {
        super(builder);
        this.sidewalk = builder.sidewalk;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public SidewalkAccountInfo sidewalk() {
        return this.sidewalk;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAwsAccountWithPartnerAccountRequest)) {
            return false;
        }
        AssociateAwsAccountWithPartnerAccountRequest other = (AssociateAwsAccountWithPartnerAccountRequest)((Object)obj);
        return Objects.equals(this.sidewalk(), other.sidewalk()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"AssociateAwsAccountWithPartnerAccountRequest").add("Sidewalk", (Object)this.sidewalk()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateAwsAccountWithPartnerAccountRequest, T> g) {
        return obj -> g.apply((AssociateAwsAccountWithPartnerAccountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private SidewalkAccountInfo sidewalk;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAwsAccountWithPartnerAccountRequest model) {
            super(model);
            this.sidewalk(model.sidewalk);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final SidewalkAccountInfo.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkAccountInfo sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final void setSidewalk(SidewalkAccountInfo.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAwsAccountWithPartnerAccountRequest build() {
            return new AssociateAwsAccountWithPartnerAccountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateAwsAccountWithPartnerAccountRequest> {
        public Builder sidewalk(SidewalkAccountInfo var1);

        default public Builder sidewalk(Consumer<SidewalkAccountInfo.Builder> sidewalk) {
            return this.sidewalk((SidewalkAccountInfo)((SidewalkAccountInfo.Builder)SidewalkAccountInfo.builder().applyMutation(sidewalk)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

