/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummariesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSyncJobsResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, ListSyncJobsResponse> {
    private static final SdkField<List<SyncJobSummary>> SYNC_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("syncJobSummaries").getter(ListSyncJobsResponse.getter(ListSyncJobsResponse::syncJobSummaries)).setter(ListSyncJobsResponse.setter(Builder::syncJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SyncJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSyncJobsResponse.getter(ListSyncJobsResponse::nextToken)).setter(ListSyncJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSyncJobsResponse.memberNameToFieldInitializer();
    private final List<SyncJobSummary> syncJobSummaries;
    private final String nextToken;

    private ListSyncJobsResponse(BuilderImpl builder) {
        super(builder);
        this.syncJobSummaries = builder.syncJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSyncJobSummaries() {
        return this.syncJobSummaries != null && !(this.syncJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<SyncJobSummary> syncJobSummaries() {
        return this.syncJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSyncJobSummaries() ? this.syncJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSyncJobsResponse)) {
            return false;
        }
        ListSyncJobsResponse other = (ListSyncJobsResponse)((Object)obj);
        return this.hasSyncJobSummaries() == other.hasSyncJobSummaries() && Objects.equals(this.syncJobSummaries(), other.syncJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSyncJobsResponse").add("SyncJobSummaries", this.hasSyncJobSummaries() ? this.syncJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "syncJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.syncJobSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("syncJobSummaries", SYNC_JOB_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSyncJobsResponse, T> g) {
        return obj -> g.apply((ListSyncJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private List<SyncJobSummary> syncJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSyncJobsResponse model) {
            super(model);
            this.syncJobSummaries(model.syncJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<SyncJobSummary.Builder> getSyncJobSummaries() {
            List<SyncJobSummary.Builder> result = SyncJobSummariesCopier.copyToBuilder(this.syncJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSyncJobSummaries(Collection<SyncJobSummary.BuilderImpl> syncJobSummaries) {
            this.syncJobSummaries = SyncJobSummariesCopier.copyFromBuilder(syncJobSummaries);
        }

        @Override
        public final Builder syncJobSummaries(Collection<SyncJobSummary> syncJobSummaries) {
            this.syncJobSummaries = SyncJobSummariesCopier.copy(syncJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syncJobSummaries(SyncJobSummary ... syncJobSummaries) {
            this.syncJobSummaries(Arrays.asList(syncJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syncJobSummaries(Consumer<SyncJobSummary.Builder> ... syncJobSummaries) {
            this.syncJobSummaries(Stream.of(syncJobSummaries).map(c -> (SyncJobSummary)((SyncJobSummary.Builder)SyncJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSyncJobsResponse build() {
            return new ListSyncJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSyncJobsResponse> {
        public Builder syncJobSummaries(Collection<SyncJobSummary> var1);

        public Builder syncJobSummaries(SyncJobSummary ... var1);

        public Builder syncJobSummaries(Consumer<SyncJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

