/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentsMapRequestCopier;
import software.amazon.awssdk.services.iottwinmaker.model.CompositeComponentRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CompositeComponentsMapRequestCopier;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEntityRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, CreateEntityRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(CreateEntityRequest.getter(CreateEntityRequest::workspaceId)).setter(CreateEntityRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(CreateEntityRequest.getter(CreateEntityRequest::entityId)).setter(CreateEntityRequest.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityName").getter(CreateEntityRequest.getter(CreateEntityRequest::entityName)).setter(CreateEntityRequest.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateEntityRequest.getter(CreateEntityRequest::description)).setter(CreateEntityRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, ComponentRequest>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("components").getter(CreateEntityRequest.getter(CreateEntityRequest::components)).setter(CreateEntityRequest.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, CompositeComponentRequest>> COMPOSITE_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("compositeComponents").getter(CreateEntityRequest.getter(CreateEntityRequest::compositeComponents)).setter(CreateEntityRequest.setter(Builder::compositeComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositeComponents").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompositeComponentRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentEntityId").getter(CreateEntityRequest.getter(CreateEntityRequest::parentEntityId)).setter(CreateEntityRequest.setter(Builder::parentEntityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateEntityRequest.getter(CreateEntityRequest::tags)).setter(CreateEntityRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, ENTITY_ID_FIELD, ENTITY_NAME_FIELD, DESCRIPTION_FIELD, COMPONENTS_FIELD, COMPOSITE_COMPONENTS_FIELD, PARENT_ENTITY_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEntityRequest.memberNameToFieldInitializer();
    private final String workspaceId;
    private final String entityId;
    private final String entityName;
    private final String description;
    private final Map<String, ComponentRequest> components;
    private final Map<String, CompositeComponentRequest> compositeComponents;
    private final String parentEntityId;
    private final Map<String, String> tags;

    private CreateEntityRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.entityId = builder.entityId;
        this.entityName = builder.entityName;
        this.description = builder.description;
        this.components = builder.components;
        this.compositeComponents = builder.compositeComponents;
        this.parentEntityId = builder.parentEntityId;
        this.tags = builder.tags;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityName() {
        return this.entityName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentRequest> components() {
        return this.components;
    }

    public final boolean hasCompositeComponents() {
        return this.compositeComponents != null && !(this.compositeComponents instanceof SdkAutoConstructMap);
    }

    public final Map<String, CompositeComponentRequest> compositeComponents() {
        return this.compositeComponents;
    }

    public final String parentEntityId() {
        return this.parentEntityId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompositeComponents() ? this.compositeComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parentEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEntityRequest)) {
            return false;
        }
        CreateEntityRequest other = (CreateEntityRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityName(), other.entityName()) && Objects.equals(this.description(), other.description()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components()) && this.hasCompositeComponents() == other.hasCompositeComponents() && Objects.equals(this.compositeComponents(), other.compositeComponents()) && Objects.equals(this.parentEntityId(), other.parentEntityId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEntityRequest").add("WorkspaceId", (Object)this.workspaceId()).add("EntityId", (Object)this.entityId()).add("EntityName", (Object)this.entityName()).add("Description", (Object)this.description()).add("Components", this.hasComponents() ? this.components() : null).add("CompositeComponents", this.hasCompositeComponents() ? this.compositeComponents() : null).add("ParentEntityId", (Object)this.parentEntityId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "compositeComponents": {
                return Optional.ofNullable(clazz.cast(this.compositeComponents()));
            }
            case "parentEntityId": {
                return Optional.ofNullable(clazz.cast(this.parentEntityId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("entityName", ENTITY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("components", COMPONENTS_FIELD);
        map.put("compositeComponents", COMPOSITE_COMPONENTS_FIELD);
        map.put("parentEntityId", PARENT_ENTITY_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEntityRequest, T> g) {
        return obj -> g.apply((CreateEntityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private String entityId;
        private String entityName;
        private String description;
        private Map<String, ComponentRequest> components = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, CompositeComponentRequest> compositeComponents = DefaultSdkAutoConstructMap.getInstance();
        private String parentEntityId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEntityRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.entityId(model.entityId);
            this.entityName(model.entityName);
            this.description(model.description);
            this.components(model.components);
            this.compositeComponents(model.compositeComponents);
            this.parentEntityId(model.parentEntityId);
            this.tags(model.tags);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityName() {
            return this.entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, ComponentRequest.Builder> getComponents() {
            Map<String, ComponentRequest.Builder> result = ComponentsMapRequestCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponents(Map<String, ComponentRequest.BuilderImpl> components) {
            this.components = ComponentsMapRequestCopier.copyFromBuilder(components);
        }

        @Override
        public final Builder components(Map<String, ComponentRequest> components) {
            this.components = ComponentsMapRequestCopier.copy(components);
            return this;
        }

        public final Map<String, CompositeComponentRequest.Builder> getCompositeComponents() {
            Map<String, CompositeComponentRequest.Builder> result = CompositeComponentsMapRequestCopier.copyToBuilder(this.compositeComponents);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompositeComponents(Map<String, CompositeComponentRequest.BuilderImpl> compositeComponents) {
            this.compositeComponents = CompositeComponentsMapRequestCopier.copyFromBuilder(compositeComponents);
        }

        @Override
        public final Builder compositeComponents(Map<String, CompositeComponentRequest> compositeComponents) {
            this.compositeComponents = CompositeComponentsMapRequestCopier.copy(compositeComponents);
            return this;
        }

        public final String getParentEntityId() {
            return this.parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
        }

        @Override
        public final Builder parentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEntityRequest build() {
            return new CreateEntityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEntityRequest> {
        public Builder workspaceId(String var1);

        public Builder entityId(String var1);

        public Builder entityName(String var1);

        public Builder description(String var1);

        public Builder components(Map<String, ComponentRequest> var1);

        public Builder compositeComponents(Map<String, CompositeComponentRequest> var1);

        public Builder parentEntityId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

