/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSyncJobRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, DeleteSyncJobRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(DeleteSyncJobRequest.getter(DeleteSyncJobRequest::workspaceId)).setter(DeleteSyncJobRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncSource").getter(DeleteSyncJobRequest.getter(DeleteSyncJobRequest::syncSource)).setter(DeleteSyncJobRequest.setter(Builder::syncSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("syncSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, SYNC_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteSyncJobRequest.memberNameToFieldInitializer();
    private final String workspaceId;
    private final String syncSource;

    private DeleteSyncJobRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.syncSource = builder.syncSource;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String syncSource() {
        return this.syncSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSyncJobRequest)) {
            return false;
        }
        DeleteSyncJobRequest other = (DeleteSyncJobRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.syncSource(), other.syncSource());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSyncJobRequest").add("WorkspaceId", (Object)this.workspaceId()).add("SyncSource", (Object)this.syncSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "syncSource": {
                return Optional.ofNullable(clazz.cast(this.syncSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("syncSource", SYNC_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSyncJobRequest, T> g) {
        return obj -> g.apply((DeleteSyncJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private String syncSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSyncJobRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.syncSource(model.syncSource);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getSyncSource() {
            return this.syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSyncJobRequest build() {
            return new DeleteSyncJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSyncJobRequest> {
        public Builder workspaceId(String var1);

        public Builder syncSource(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

