/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.SelectedPropertyListCopier;
import software.amazon.awssdk.services.iottwinmaker.model.TabularConditions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPropertyValueRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, GetPropertyValueRequest> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(GetPropertyValueRequest.getter(GetPropertyValueRequest::componentName)).setter(GetPropertyValueRequest.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentPath").getter(GetPropertyValueRequest.getter(GetPropertyValueRequest::componentPath)).setter(GetPropertyValueRequest.setter(Builder::componentPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentPath").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(GetPropertyValueRequest.getter(GetPropertyValueRequest::componentTypeId)).setter(GetPropertyValueRequest.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(GetPropertyValueRequest.getter(GetPropertyValueRequest::entityId)).setter(GetPropertyValueRequest.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<List<String>> SELECTED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("selectedProperties").getter(GetPropertyValueRequest.getter(GetPropertyValueRequest::selectedProperties)).setter(GetPropertyValueRequest.setter(Builder::selectedProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(GetPropertyValueRequest.getter(GetPropertyValueRequest::workspaceId)).setter(GetPropertyValueRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetPropertyValueRequest.getter(GetPropertyValueRequest::maxResults)).setter(GetPropertyValueRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetPropertyValueRequest.getter(GetPropertyValueRequest::nextToken)).setter(GetPropertyValueRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> PROPERTY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyGroupName").getter(GetPropertyValueRequest.getter(GetPropertyValueRequest::propertyGroupName)).setter(GetPropertyValueRequest.setter(Builder::propertyGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroupName").build()}).build();
    private static final SdkField<TabularConditions> TABULAR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tabularConditions").getter(GetPropertyValueRequest.getter(GetPropertyValueRequest::tabularConditions)).setter(GetPropertyValueRequest.setter(Builder::tabularConditions)).constructor(TabularConditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tabularConditions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, COMPONENT_PATH_FIELD, COMPONENT_TYPE_ID_FIELD, ENTITY_ID_FIELD, SELECTED_PROPERTIES_FIELD, WORKSPACE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PROPERTY_GROUP_NAME_FIELD, TABULAR_CONDITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPropertyValueRequest.memberNameToFieldInitializer();
    private final String componentName;
    private final String componentPath;
    private final String componentTypeId;
    private final String entityId;
    private final List<String> selectedProperties;
    private final String workspaceId;
    private final Integer maxResults;
    private final String nextToken;
    private final String propertyGroupName;
    private final TabularConditions tabularConditions;

    private GetPropertyValueRequest(BuilderImpl builder) {
        super(builder);
        this.componentName = builder.componentName;
        this.componentPath = builder.componentPath;
        this.componentTypeId = builder.componentTypeId;
        this.entityId = builder.entityId;
        this.selectedProperties = builder.selectedProperties;
        this.workspaceId = builder.workspaceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.propertyGroupName = builder.propertyGroupName;
        this.tabularConditions = builder.tabularConditions;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentPath() {
        return this.componentPath;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final boolean hasSelectedProperties() {
        return this.selectedProperties != null && !(this.selectedProperties instanceof SdkAutoConstructList);
    }

    public final List<String> selectedProperties() {
        return this.selectedProperties;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String propertyGroupName() {
        return this.propertyGroupName;
    }

    public final TabularConditions tabularConditions() {
        return this.tabularConditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedProperties() ? this.selectedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tabularConditions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPropertyValueRequest)) {
            return false;
        }
        GetPropertyValueRequest other = (GetPropertyValueRequest)((Object)obj);
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentPath(), other.componentPath()) && Objects.equals(this.componentTypeId(), other.componentTypeId()) && Objects.equals(this.entityId(), other.entityId()) && this.hasSelectedProperties() == other.hasSelectedProperties() && Objects.equals(this.selectedProperties(), other.selectedProperties()) && Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.propertyGroupName(), other.propertyGroupName()) && Objects.equals(this.tabularConditions(), other.tabularConditions());
    }

    public final String toString() {
        return ToString.builder((String)"GetPropertyValueRequest").add("ComponentName", (Object)this.componentName()).add("ComponentPath", (Object)this.componentPath()).add("ComponentTypeId", (Object)this.componentTypeId()).add("EntityId", (Object)this.entityId()).add("SelectedProperties", this.hasSelectedProperties() ? this.selectedProperties() : null).add("WorkspaceId", (Object)this.workspaceId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("PropertyGroupName", (Object)this.propertyGroupName()).add("TabularConditions", (Object)this.tabularConditions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentPath": {
                return Optional.ofNullable(clazz.cast(this.componentPath()));
            }
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "selectedProperties": {
                return Optional.ofNullable(clazz.cast(this.selectedProperties()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "propertyGroupName": {
                return Optional.ofNullable(clazz.cast(this.propertyGroupName()));
            }
            case "tabularConditions": {
                return Optional.ofNullable(clazz.cast(this.tabularConditions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("componentPath", COMPONENT_PATH_FIELD);
        map.put("componentTypeId", COMPONENT_TYPE_ID_FIELD);
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("selectedProperties", SELECTED_PROPERTIES_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("propertyGroupName", PROPERTY_GROUP_NAME_FIELD);
        map.put("tabularConditions", TABULAR_CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPropertyValueRequest, T> g) {
        return obj -> g.apply((GetPropertyValueRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String componentName;
        private String componentPath;
        private String componentTypeId;
        private String entityId;
        private List<String> selectedProperties = DefaultSdkAutoConstructList.getInstance();
        private String workspaceId;
        private Integer maxResults;
        private String nextToken;
        private String propertyGroupName;
        private TabularConditions tabularConditions;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPropertyValueRequest model) {
            super(model);
            this.componentName(model.componentName);
            this.componentPath(model.componentPath);
            this.componentTypeId(model.componentTypeId);
            this.entityId(model.entityId);
            this.selectedProperties(model.selectedProperties);
            this.workspaceId(model.workspaceId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.propertyGroupName(model.propertyGroupName);
            this.tabularConditions(model.tabularConditions);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentPath() {
            return this.componentPath;
        }

        public final void setComponentPath(String componentPath) {
            this.componentPath = componentPath;
        }

        @Override
        public final Builder componentPath(String componentPath) {
            this.componentPath = componentPath;
            return this;
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final Collection<String> getSelectedProperties() {
            if (this.selectedProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedProperties;
        }

        public final void setSelectedProperties(Collection<String> selectedProperties) {
            this.selectedProperties = SelectedPropertyListCopier.copy(selectedProperties);
        }

        @Override
        public final Builder selectedProperties(Collection<String> selectedProperties) {
            this.selectedProperties = SelectedPropertyListCopier.copy(selectedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedProperties(String ... selectedProperties) {
            this.selectedProperties(Arrays.asList(selectedProperties));
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPropertyGroupName() {
            return this.propertyGroupName;
        }

        public final void setPropertyGroupName(String propertyGroupName) {
            this.propertyGroupName = propertyGroupName;
        }

        @Override
        public final Builder propertyGroupName(String propertyGroupName) {
            this.propertyGroupName = propertyGroupName;
            return this;
        }

        public final TabularConditions.Builder getTabularConditions() {
            return this.tabularConditions != null ? this.tabularConditions.toBuilder() : null;
        }

        public final void setTabularConditions(TabularConditions.BuilderImpl tabularConditions) {
            this.tabularConditions = tabularConditions != null ? tabularConditions.build() : null;
        }

        @Override
        public final Builder tabularConditions(TabularConditions tabularConditions) {
            this.tabularConditions = tabularConditions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPropertyValueRequest build() {
            return new GetPropertyValueRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPropertyValueRequest> {
        public Builder componentName(String var1);

        public Builder componentPath(String var1);

        public Builder componentTypeId(String var1);

        public Builder entityId(String var1);

        public Builder selectedProperties(Collection<String> var1);

        public Builder selectedProperties(String ... var1);

        public Builder workspaceId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder propertyGroupName(String var1);

        public Builder tabularConditions(TabularConditions var1);

        default public Builder tabularConditions(Consumer<TabularConditions.Builder> tabularConditions) {
            return this.tabularConditions((TabularConditions)((TabularConditions.Builder)TabularConditions.builder().applyMutation(tabularConditions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

