/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntitySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntitySummary> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(EntitySummary.getter(EntitySummary::entityId)).setter(EntitySummary.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityName").getter(EntitySummary.getter(EntitySummary::entityName)).setter(EntitySummary.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EntitySummary.getter(EntitySummary::arn)).setter(EntitySummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentEntityId").getter(EntitySummary.getter(EntitySummary::parentEntityId)).setter(EntitySummary.setter(Builder::parentEntityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()}).build();
    private static final SdkField<Status> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(EntitySummary.getter(EntitySummary::status)).setter(EntitySummary.setter(Builder::status)).constructor(Status::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(EntitySummary.getter(EntitySummary::description)).setter(EntitySummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> HAS_CHILD_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hasChildEntities").getter(EntitySummary.getter(EntitySummary::hasChildEntities)).setter(EntitySummary.setter(Builder::hasChildEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasChildEntities").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(EntitySummary.getter(EntitySummary::creationDateTime)).setter(EntitySummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(EntitySummary.getter(EntitySummary::updateDateTime)).setter(EntitySummary.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, ENTITY_NAME_FIELD, ARN_FIELD, PARENT_ENTITY_ID_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, HAS_CHILD_ENTITIES_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EntitySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entityId;
    private final String entityName;
    private final String arn;
    private final String parentEntityId;
    private final Status status;
    private final String description;
    private final Boolean hasChildEntities;
    private final Instant creationDateTime;
    private final Instant updateDateTime;

    private EntitySummary(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.entityName = builder.entityName;
        this.arn = builder.arn;
        this.parentEntityId = builder.parentEntityId;
        this.status = builder.status;
        this.description = builder.description;
        this.hasChildEntities = builder.hasChildEntities;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityName() {
        return this.entityName;
    }

    public final String arn() {
        return this.arn;
    }

    public final String parentEntityId() {
        return this.parentEntityId;
    }

    public final Status status() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean hasChildEntities() {
        return this.hasChildEntities;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildEntities());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitySummary)) {
            return false;
        }
        EntitySummary other = (EntitySummary)obj;
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityName(), other.entityName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.parentEntityId(), other.parentEntityId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.hasChildEntities(), other.hasChildEntities()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.updateDateTime(), other.updateDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"EntitySummary").add("EntityId", (Object)this.entityId()).add("EntityName", (Object)this.entityName()).add("Arn", (Object)this.arn()).add("ParentEntityId", (Object)this.parentEntityId()).add("Status", (Object)this.status()).add("Description", (Object)this.description()).add("HasChildEntities", (Object)this.hasChildEntities()).add("CreationDateTime", (Object)this.creationDateTime()).add("UpdateDateTime", (Object)this.updateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "parentEntityId": {
                return Optional.ofNullable(clazz.cast(this.parentEntityId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "hasChildEntities": {
                return Optional.ofNullable(clazz.cast(this.hasChildEntities()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("entityName", ENTITY_NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("parentEntityId", PARENT_ENTITY_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("hasChildEntities", HAS_CHILD_ENTITIES_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("updateDateTime", UPDATE_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EntitySummary, T> g) {
        return obj -> g.apply((EntitySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityId;
        private String entityName;
        private String arn;
        private String parentEntityId;
        private Status status;
        private String description;
        private Boolean hasChildEntities;
        private Instant creationDateTime;
        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EntitySummary model) {
            this.entityId(model.entityId);
            this.entityName(model.entityName);
            this.arn(model.arn);
            this.parentEntityId(model.parentEntityId);
            this.status(model.status);
            this.description(model.description);
            this.hasChildEntities(model.hasChildEntities);
            this.creationDateTime(model.creationDateTime);
            this.updateDateTime(model.updateDateTime);
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityName() {
            return this.entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getParentEntityId() {
            return this.parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
        }

        @Override
        public final Builder parentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        public final Status.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getHasChildEntities() {
            return this.hasChildEntities;
        }

        public final void setHasChildEntities(Boolean hasChildEntities) {
            this.hasChildEntities = hasChildEntities;
        }

        @Override
        public final Builder hasChildEntities(Boolean hasChildEntities) {
            this.hasChildEntities = hasChildEntities;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public EntitySummary build() {
            return new EntitySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntitySummary> {
        public Builder entityId(String var1);

        public Builder entityName(String var1);

        public Builder arn(String var1);

        public Builder parentEntityId(String var1);

        public Builder status(Status var1);

        default public Builder status(Consumer<Status.Builder> status) {
            return this.status((Status)((Status.Builder)Status.builder().applyMutation(status)).build());
        }

        public Builder description(String var1);

        public Builder hasChildEntities(Boolean var1);

        public Builder creationDateTime(Instant var1);

        public Builder updateDateTime(Instant var1);
    }
}

