/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState;
import software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SyncResourceFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SyncResourceFilter> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(SyncResourceFilter.getter(SyncResourceFilter::stateAsString)).setter(SyncResourceFilter.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(SyncResourceFilter.getter(SyncResourceFilter::resourceTypeAsString)).setter(SyncResourceFilter.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(SyncResourceFilter.getter(SyncResourceFilter::resourceId)).setter(SyncResourceFilter.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(SyncResourceFilter.getter(SyncResourceFilter::externalId)).setter(SyncResourceFilter.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, EXTERNAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SyncResourceFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String state;
    private final String resourceType;
    private final String resourceId;
    private final String externalId;
    private final Type type;

    private SyncResourceFilter(BuilderImpl builder) {
        this.state = builder.state;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.externalId = builder.externalId;
        this.type = builder.type;
    }

    public final SyncResourceState state() {
        return SyncResourceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final SyncResourceType resourceType() {
        return SyncResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String externalId() {
        return this.externalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncResourceFilter)) {
            return false;
        }
        SyncResourceFilter other = (SyncResourceFilter)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.externalId(), other.externalId());
    }

    public final String toString() {
        return ToString.builder((String)"SyncResourceFilter").add("State", (Object)this.stateAsString()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("ExternalId", (Object)this.externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
        }
        return Optional.empty();
    }

    public static SyncResourceFilter fromState(String state) {
        return (SyncResourceFilter)SyncResourceFilter.builder().state(state).build();
    }

    public static SyncResourceFilter fromState(SyncResourceState state) {
        return (SyncResourceFilter)SyncResourceFilter.builder().state(state).build();
    }

    public static SyncResourceFilter fromResourceType(String resourceType) {
        return (SyncResourceFilter)SyncResourceFilter.builder().resourceType(resourceType).build();
    }

    public static SyncResourceFilter fromResourceType(SyncResourceType resourceType) {
        return (SyncResourceFilter)SyncResourceFilter.builder().resourceType(resourceType).build();
    }

    public static SyncResourceFilter fromResourceId(String resourceId) {
        return (SyncResourceFilter)SyncResourceFilter.builder().resourceId(resourceId).build();
    }

    public static SyncResourceFilter fromExternalId(String externalId) {
        return (SyncResourceFilter)SyncResourceFilter.builder().externalId(externalId).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("state", STATE_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SyncResourceFilter, T> g) {
        return obj -> g.apply((SyncResourceFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STATE,
        RESOURCE_TYPE,
        RESOURCE_ID,
        EXTERNAL_ID,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String resourceType;
        private String resourceId;
        private String externalId;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SyncResourceFilter model) {
            this.state(model.state);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.externalId(model.externalId);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            String oldValue = this.state;
            this.state = state;
            this.handleUnionValueChange(Type.STATE, oldValue, this.state);
        }

        @Override
        public final Builder state(String state) {
            String oldValue = this.state;
            this.state = state;
            this.handleUnionValueChange(Type.STATE, oldValue, this.state);
            return this;
        }

        @Override
        public final Builder state(SyncResourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            String oldValue = this.resourceType;
            this.resourceType = resourceType;
            this.handleUnionValueChange(Type.RESOURCE_TYPE, oldValue, this.resourceType);
        }

        @Override
        public final Builder resourceType(String resourceType) {
            String oldValue = this.resourceType;
            this.resourceType = resourceType;
            this.handleUnionValueChange(Type.RESOURCE_TYPE, oldValue, this.resourceType);
            return this;
        }

        @Override
        public final Builder resourceType(SyncResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            String oldValue = this.resourceId;
            this.resourceId = resourceId;
            this.handleUnionValueChange(Type.RESOURCE_ID, oldValue, this.resourceId);
        }

        @Override
        public final Builder resourceId(String resourceId) {
            String oldValue = this.resourceId;
            this.resourceId = resourceId;
            this.handleUnionValueChange(Type.RESOURCE_ID, oldValue, this.resourceId);
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            String oldValue = this.externalId;
            this.externalId = externalId;
            this.handleUnionValueChange(Type.EXTERNAL_ID, oldValue, this.externalId);
        }

        @Override
        public final Builder externalId(String externalId) {
            String oldValue = this.externalId;
            this.externalId = externalId;
            this.handleUnionValueChange(Type.EXTERNAL_ID, oldValue, this.externalId);
            return this;
        }

        public SyncResourceFilter build() {
            return new SyncResourceFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SyncResourceFilter> {
        public Builder state(String var1);

        public Builder state(SyncResourceState var1);

        public Builder resourceType(String var1);

        public Builder resourceType(SyncResourceType var1);

        public Builder resourceId(String var1);

        public Builder externalId(String var1);
    }
}

