/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.FilterByComponentType;
import software.amazon.awssdk.services.iottwinmaker.model.FilterByEntity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IotTwinMakerSourceConfigurationFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IotTwinMakerSourceConfigurationFilter> {
    private static final SdkField<FilterByComponentType> FILTER_BY_COMPONENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterByComponentType").getter(IotTwinMakerSourceConfigurationFilter.getter(IotTwinMakerSourceConfigurationFilter::filterByComponentType)).setter(IotTwinMakerSourceConfigurationFilter.setter(Builder::filterByComponentType)).constructor(FilterByComponentType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByComponentType").build()}).build();
    private static final SdkField<FilterByEntity> FILTER_BY_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterByEntity").getter(IotTwinMakerSourceConfigurationFilter.getter(IotTwinMakerSourceConfigurationFilter::filterByEntity)).setter(IotTwinMakerSourceConfigurationFilter.setter(Builder::filterByEntity)).constructor(FilterByEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByEntity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_BY_COMPONENT_TYPE_FIELD, FILTER_BY_ENTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IotTwinMakerSourceConfigurationFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FilterByComponentType filterByComponentType;
    private final FilterByEntity filterByEntity;
    private final Type type;

    private IotTwinMakerSourceConfigurationFilter(BuilderImpl builder) {
        this.filterByComponentType = builder.filterByComponentType;
        this.filterByEntity = builder.filterByEntity;
        this.type = builder.type;
    }

    public final FilterByComponentType filterByComponentType() {
        return this.filterByComponentType;
    }

    public final FilterByEntity filterByEntity() {
        return this.filterByEntity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByComponentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByEntity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotTwinMakerSourceConfigurationFilter)) {
            return false;
        }
        IotTwinMakerSourceConfigurationFilter other = (IotTwinMakerSourceConfigurationFilter)obj;
        return Objects.equals(this.filterByComponentType(), other.filterByComponentType()) && Objects.equals(this.filterByEntity(), other.filterByEntity());
    }

    public final String toString() {
        return ToString.builder((String)"IotTwinMakerSourceConfigurationFilter").add("FilterByComponentType", (Object)this.filterByComponentType()).add("FilterByEntity", (Object)this.filterByEntity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterByComponentType": {
                return Optional.ofNullable(clazz.cast(this.filterByComponentType()));
            }
            case "filterByEntity": {
                return Optional.ofNullable(clazz.cast(this.filterByEntity()));
            }
        }
        return Optional.empty();
    }

    public static IotTwinMakerSourceConfigurationFilter fromFilterByComponentType(FilterByComponentType filterByComponentType) {
        return (IotTwinMakerSourceConfigurationFilter)IotTwinMakerSourceConfigurationFilter.builder().filterByComponentType(filterByComponentType).build();
    }

    public static IotTwinMakerSourceConfigurationFilter fromFilterByComponentType(Consumer<FilterByComponentType.Builder> filterByComponentType) {
        FilterByComponentType.Builder builder = FilterByComponentType.builder();
        filterByComponentType.accept(builder);
        return IotTwinMakerSourceConfigurationFilter.fromFilterByComponentType((FilterByComponentType)builder.build());
    }

    public static IotTwinMakerSourceConfigurationFilter fromFilterByEntity(FilterByEntity filterByEntity) {
        return (IotTwinMakerSourceConfigurationFilter)IotTwinMakerSourceConfigurationFilter.builder().filterByEntity(filterByEntity).build();
    }

    public static IotTwinMakerSourceConfigurationFilter fromFilterByEntity(Consumer<FilterByEntity.Builder> filterByEntity) {
        FilterByEntity.Builder builder = FilterByEntity.builder();
        filterByEntity.accept(builder);
        return IotTwinMakerSourceConfigurationFilter.fromFilterByEntity((FilterByEntity)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterByComponentType", FILTER_BY_COMPONENT_TYPE_FIELD);
        map.put("filterByEntity", FILTER_BY_ENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IotTwinMakerSourceConfigurationFilter, T> g) {
        return obj -> g.apply((IotTwinMakerSourceConfigurationFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FILTER_BY_COMPONENT_TYPE,
        FILTER_BY_ENTITY,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private FilterByComponentType filterByComponentType;
        private FilterByEntity filterByEntity;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IotTwinMakerSourceConfigurationFilter model) {
            this.filterByComponentType(model.filterByComponentType);
            this.filterByEntity(model.filterByEntity);
        }

        public final FilterByComponentType.Builder getFilterByComponentType() {
            return this.filterByComponentType != null ? this.filterByComponentType.toBuilder() : null;
        }

        public final void setFilterByComponentType(FilterByComponentType.BuilderImpl filterByComponentType) {
            FilterByComponentType oldValue = this.filterByComponentType;
            this.filterByComponentType = filterByComponentType != null ? filterByComponentType.build() : null;
            this.handleUnionValueChange(Type.FILTER_BY_COMPONENT_TYPE, oldValue, this.filterByComponentType);
        }

        @Override
        public final Builder filterByComponentType(FilterByComponentType filterByComponentType) {
            FilterByComponentType oldValue = this.filterByComponentType;
            this.filterByComponentType = filterByComponentType;
            this.handleUnionValueChange(Type.FILTER_BY_COMPONENT_TYPE, oldValue, this.filterByComponentType);
            return this;
        }

        public final FilterByEntity.Builder getFilterByEntity() {
            return this.filterByEntity != null ? this.filterByEntity.toBuilder() : null;
        }

        public final void setFilterByEntity(FilterByEntity.BuilderImpl filterByEntity) {
            FilterByEntity oldValue = this.filterByEntity;
            this.filterByEntity = filterByEntity != null ? filterByEntity.build() : null;
            this.handleUnionValueChange(Type.FILTER_BY_ENTITY, oldValue, this.filterByEntity);
        }

        @Override
        public final Builder filterByEntity(FilterByEntity filterByEntity) {
            FilterByEntity oldValue = this.filterByEntity;
            this.filterByEntity = filterByEntity;
            this.handleUnionValueChange(Type.FILTER_BY_ENTITY, oldValue, this.filterByEntity);
            return this;
        }

        public IotTwinMakerSourceConfigurationFilter build() {
            return new IotTwinMakerSourceConfigurationFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IotTwinMakerSourceConfigurationFilter> {
        public Builder filterByComponentType(FilterByComponentType var1);

        default public Builder filterByComponentType(Consumer<FilterByComponentType.Builder> filterByComponentType) {
            return this.filterByComponentType((FilterByComponentType)((FilterByComponentType.Builder)FilterByComponentType.builder().applyMutation(filterByComponentType)).build());
        }

        public Builder filterByEntity(FilterByEntity var1);

        default public Builder filterByEntity(Consumer<FilterByEntity.Builder> filterByEntity) {
            return this.filterByEntity((FilterByEntity)((FilterByEntity.Builder)FilterByEntity.builder().applyMutation(filterByEntity)).build());
        }
    }
}

