/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.IotTwinMakerSourceConfigurationFilter;
import software.amazon.awssdk.services.iottwinmaker.model.IotTwinMakerSourceConfigurationFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IotTwinMakerSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IotTwinMakerSourceConfiguration> {
    private static final SdkField<String> WORKSPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspace").getter(IotTwinMakerSourceConfiguration.getter(IotTwinMakerSourceConfiguration::workspace)).setter(IotTwinMakerSourceConfiguration.setter(Builder::workspace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspace").build()}).build();
    private static final SdkField<List<IotTwinMakerSourceConfigurationFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(IotTwinMakerSourceConfiguration.getter(IotTwinMakerSourceConfiguration::filters)).setter(IotTwinMakerSourceConfiguration.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IotTwinMakerSourceConfigurationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IotTwinMakerSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workspace;
    private final List<IotTwinMakerSourceConfigurationFilter> filters;

    private IotTwinMakerSourceConfiguration(BuilderImpl builder) {
        this.workspace = builder.workspace;
        this.filters = builder.filters;
    }

    public final String workspace() {
        return this.workspace;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<IotTwinMakerSourceConfigurationFilter> filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workspace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotTwinMakerSourceConfiguration)) {
            return false;
        }
        IotTwinMakerSourceConfiguration other = (IotTwinMakerSourceConfiguration)obj;
        return Objects.equals(this.workspace(), other.workspace()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"IotTwinMakerSourceConfiguration").add("Workspace", (Object)this.workspace()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspace": {
                return Optional.ofNullable(clazz.cast(this.workspace()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workspace", WORKSPACE_FIELD);
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IotTwinMakerSourceConfiguration, T> g) {
        return obj -> g.apply((IotTwinMakerSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workspace;
        private List<IotTwinMakerSourceConfigurationFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IotTwinMakerSourceConfiguration model) {
            this.workspace(model.workspace);
            this.filters(model.filters);
        }

        public final String getWorkspace() {
            return this.workspace;
        }

        public final void setWorkspace(String workspace) {
            this.workspace = workspace;
        }

        @Override
        public final Builder workspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        public final List<IotTwinMakerSourceConfigurationFilter.Builder> getFilters() {
            List<IotTwinMakerSourceConfigurationFilter.Builder> result = IotTwinMakerSourceConfigurationFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<IotTwinMakerSourceConfigurationFilter.BuilderImpl> filters) {
            this.filters = IotTwinMakerSourceConfigurationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<IotTwinMakerSourceConfigurationFilter> filters) {
            this.filters = IotTwinMakerSourceConfigurationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IotTwinMakerSourceConfigurationFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IotTwinMakerSourceConfigurationFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (IotTwinMakerSourceConfigurationFilter)((IotTwinMakerSourceConfigurationFilter.Builder)IotTwinMakerSourceConfigurationFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IotTwinMakerSourceConfiguration build() {
            return new IotTwinMakerSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IotTwinMakerSourceConfiguration> {
        public Builder workspace(String var1);

        public Builder filters(Collection<IotTwinMakerSourceConfigurationFilter> var1);

        public Builder filters(IotTwinMakerSourceConfigurationFilter ... var1);

        public Builder filters(Consumer<IotTwinMakerSourceConfigurationFilter.Builder> ... var1);
    }
}

