/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ColumnType {
    NODE("NODE"),
    EDGE("EDGE"),
    VALUE("VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ColumnType> VALUE_MAP;
    private final String value;

    private ColumnType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ColumnType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ColumnType> knownValues() {
        EnumSet<ColumnType> knownValues = EnumSet.allOf(ColumnType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ColumnType.class, ColumnType::toString);
    }
}

