/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.DestinationConfiguration;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.MetadataTransferJobProgress;
import software.amazon.awssdk.services.iottwinmaker.model.MetadataTransferJobStatus;
import software.amazon.awssdk.services.iottwinmaker.model.SourceConfiguration;
import software.amazon.awssdk.services.iottwinmaker.model.SourceConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetadataTransferJobResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, GetMetadataTransferJobResponse> {
    private static final SdkField<String> METADATA_TRANSFER_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadataTransferJobId").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::metadataTransferJobId)).setter(GetMetadataTransferJobResponse.setter(Builder::metadataTransferJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::arn)).setter(GetMetadataTransferJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::description)).setter(GetMetadataTransferJobResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<SourceConfiguration>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::sources)).setter(GetMetadataTransferJobResponse.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DestinationConfiguration> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destination").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::destination)).setter(GetMetadataTransferJobResponse.setter(Builder::destination)).constructor(DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> METADATA_TRANSFER_JOB_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadataTransferJobRole").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::metadataTransferJobRole)).setter(GetMetadataTransferJobResponse.setter(Builder::metadataTransferJobRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobRole").build()}).build();
    private static final SdkField<String> REPORT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportUrl").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::reportUrl)).setter(GetMetadataTransferJobResponse.setter(Builder::reportUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportUrl").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::creationDateTime)).setter(GetMetadataTransferJobResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::updateDateTime)).setter(GetMetadataTransferJobResponse.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final SdkField<MetadataTransferJobStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::status)).setter(GetMetadataTransferJobResponse.setter(Builder::status)).constructor(MetadataTransferJobStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<MetadataTransferJobProgress> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("progress").getter(GetMetadataTransferJobResponse.getter(GetMetadataTransferJobResponse::progress)).setter(GetMetadataTransferJobResponse.setter(Builder::progress)).constructor(MetadataTransferJobProgress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_TRANSFER_JOB_ID_FIELD, ARN_FIELD, DESCRIPTION_FIELD, SOURCES_FIELD, DESTINATION_FIELD, METADATA_TRANSFER_JOB_ROLE_FIELD, REPORT_URL_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD, STATUS_FIELD, PROGRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("metadataTransferJobId", METADATA_TRANSFER_JOB_ID_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("sources", SOURCES_FIELD);
            this.put("destination", DESTINATION_FIELD);
            this.put("metadataTransferJobRole", METADATA_TRANSFER_JOB_ROLE_FIELD);
            this.put("reportUrl", REPORT_URL_FIELD);
            this.put("creationDateTime", CREATION_DATE_TIME_FIELD);
            this.put("updateDateTime", UPDATE_DATE_TIME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("progress", PROGRESS_FIELD);
        }
    });
    private final String metadataTransferJobId;
    private final String arn;
    private final String description;
    private final List<SourceConfiguration> sources;
    private final DestinationConfiguration destination;
    private final String metadataTransferJobRole;
    private final String reportUrl;
    private final Instant creationDateTime;
    private final Instant updateDateTime;
    private final MetadataTransferJobStatus status;
    private final MetadataTransferJobProgress progress;

    private GetMetadataTransferJobResponse(BuilderImpl builder) {
        super(builder);
        this.metadataTransferJobId = builder.metadataTransferJobId;
        this.arn = builder.arn;
        this.description = builder.description;
        this.sources = builder.sources;
        this.destination = builder.destination;
        this.metadataTransferJobRole = builder.metadataTransferJobRole;
        this.reportUrl = builder.reportUrl;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
        this.status = builder.status;
        this.progress = builder.progress;
    }

    public final String metadataTransferJobId() {
        return this.metadataTransferJobId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<SourceConfiguration> sources() {
        return this.sources;
    }

    public final DestinationConfiguration destination() {
        return this.destination;
    }

    public final String metadataTransferJobRole() {
        return this.metadataTransferJobRole;
    }

    public final String reportUrl() {
        return this.reportUrl;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public final MetadataTransferJobStatus status() {
        return this.status;
    }

    public final MetadataTransferJobProgress progress() {
        return this.progress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataTransferJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataTransferJobRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetadataTransferJobResponse)) {
            return false;
        }
        GetMetadataTransferJobResponse other = (GetMetadataTransferJobResponse)((Object)obj);
        return Objects.equals(this.metadataTransferJobId(), other.metadataTransferJobId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.metadataTransferJobRole(), other.metadataTransferJobRole()) && Objects.equals(this.reportUrl(), other.reportUrl()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.progress(), other.progress());
    }

    public final String toString() {
        return ToString.builder((String)"GetMetadataTransferJobResponse").add("MetadataTransferJobId", (Object)this.metadataTransferJobId()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Sources", this.hasSources() ? this.sources() : null).add("Destination", (Object)this.destination()).add("MetadataTransferJobRole", (Object)this.metadataTransferJobRole()).add("ReportUrl", (Object)this.reportUrl()).add("CreationDateTime", (Object)this.creationDateTime()).add("UpdateDateTime", (Object)this.updateDateTime()).add("Status", (Object)this.status()).add("Progress", (Object)this.progress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metadataTransferJobId": {
                return Optional.ofNullable(clazz.cast(this.metadataTransferJobId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "metadataTransferJobRole": {
                return Optional.ofNullable(clazz.cast(this.metadataTransferJobRole()));
            }
            case "reportUrl": {
                return Optional.ofNullable(clazz.cast(this.reportUrl()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMetadataTransferJobResponse, T> g) {
        return obj -> g.apply((GetMetadataTransferJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private String metadataTransferJobId;
        private String arn;
        private String description;
        private List<SourceConfiguration> sources = DefaultSdkAutoConstructList.getInstance();
        private DestinationConfiguration destination;
        private String metadataTransferJobRole;
        private String reportUrl;
        private Instant creationDateTime;
        private Instant updateDateTime;
        private MetadataTransferJobStatus status;
        private MetadataTransferJobProgress progress;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetadataTransferJobResponse model) {
            super(model);
            this.metadataTransferJobId(model.metadataTransferJobId);
            this.arn(model.arn);
            this.description(model.description);
            this.sources(model.sources);
            this.destination(model.destination);
            this.metadataTransferJobRole(model.metadataTransferJobRole);
            this.reportUrl(model.reportUrl);
            this.creationDateTime(model.creationDateTime);
            this.updateDateTime(model.updateDateTime);
            this.status(model.status);
            this.progress(model.progress);
        }

        public final String getMetadataTransferJobId() {
            return this.metadataTransferJobId;
        }

        public final void setMetadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
        }

        @Override
        public final Builder metadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SourceConfiguration.Builder> getSources() {
            List<SourceConfiguration.Builder> result = SourceConfigurationsCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<SourceConfiguration.BuilderImpl> sources) {
            this.sources = SourceConfigurationsCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<SourceConfiguration> sources) {
            this.sources = SourceConfigurationsCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(SourceConfiguration ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<SourceConfiguration.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (SourceConfiguration)((SourceConfiguration.Builder)SourceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DestinationConfiguration.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(DestinationConfiguration.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DestinationConfiguration destination) {
            this.destination = destination;
            return this;
        }

        public final String getMetadataTransferJobRole() {
            return this.metadataTransferJobRole;
        }

        public final void setMetadataTransferJobRole(String metadataTransferJobRole) {
            this.metadataTransferJobRole = metadataTransferJobRole;
        }

        @Override
        public final Builder metadataTransferJobRole(String metadataTransferJobRole) {
            this.metadataTransferJobRole = metadataTransferJobRole;
            return this;
        }

        public final String getReportUrl() {
            return this.reportUrl;
        }

        public final void setReportUrl(String reportUrl) {
            this.reportUrl = reportUrl;
        }

        @Override
        public final Builder reportUrl(String reportUrl) {
            this.reportUrl = reportUrl;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final MetadataTransferJobStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(MetadataTransferJobStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(MetadataTransferJobStatus status) {
            this.status = status;
            return this;
        }

        public final MetadataTransferJobProgress.Builder getProgress() {
            return this.progress != null ? this.progress.toBuilder() : null;
        }

        public final void setProgress(MetadataTransferJobProgress.BuilderImpl progress) {
            this.progress = progress != null ? progress.build() : null;
        }

        @Override
        public final Builder progress(MetadataTransferJobProgress progress) {
            this.progress = progress;
            return this;
        }

        @Override
        public GetMetadataTransferJobResponse build() {
            return new GetMetadataTransferJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetadataTransferJobResponse> {
        public Builder metadataTransferJobId(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder sources(Collection<SourceConfiguration> var1);

        public Builder sources(SourceConfiguration ... var1);

        public Builder sources(Consumer<SourceConfiguration.Builder> ... var1);

        public Builder destination(DestinationConfiguration var1);

        default public Builder destination(Consumer<DestinationConfiguration.Builder> destination) {
            return this.destination((DestinationConfiguration)((DestinationConfiguration.Builder)DestinationConfiguration.builder().applyMutation(destination)).build());
        }

        public Builder metadataTransferJobRole(String var1);

        public Builder reportUrl(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder updateDateTime(Instant var1);

        public Builder status(MetadataTransferJobStatus var1);

        default public Builder status(Consumer<MetadataTransferJobStatus.Builder> status) {
            return this.status((MetadataTransferJobStatus)((MetadataTransferJobStatus.Builder)MetadataTransferJobStatus.builder().applyMutation(status)).build());
        }

        public Builder progress(MetadataTransferJobProgress var1);

        default public Builder progress(Consumer<MetadataTransferJobProgress.Builder> progress) {
            return this.progress((MetadataTransferJobProgress)((MetadataTransferJobProgress.Builder)MetadataTransferJobProgress.builder().applyMutation(progress)).build());
        }
    }
}

