/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComponentTypeRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, GetComponentTypeRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(GetComponentTypeRequest.getter(GetComponentTypeRequest::workspaceId)).setter(GetComponentTypeRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(GetComponentTypeRequest.getter(GetComponentTypeRequest::componentTypeId)).setter(GetComponentTypeRequest.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("componentTypeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, COMPONENT_TYPE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("workspaceId", WORKSPACE_ID_FIELD);
            this.put("componentTypeId", COMPONENT_TYPE_ID_FIELD);
        }
    });
    private final String workspaceId;
    private final String componentTypeId;

    private GetComponentTypeRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.componentTypeId = builder.componentTypeId;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentTypeRequest)) {
            return false;
        }
        GetComponentTypeRequest other = (GetComponentTypeRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.componentTypeId(), other.componentTypeId());
    }

    public final String toString() {
        return ToString.builder((String)"GetComponentTypeRequest").add("WorkspaceId", (Object)this.workspaceId()).add("ComponentTypeId", (Object)this.componentTypeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentTypeRequest, T> g) {
        return obj -> g.apply((GetComponentTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private String componentTypeId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentTypeRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.componentTypeId(model.componentTypeId);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComponentTypeRequest build() {
            return new GetComponentTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComponentTypeRequest> {
        public Builder workspaceId(String var1);

        public Builder componentTypeId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

