/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.MetadataTransferJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMetadataTransferJobResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, CreateMetadataTransferJobResponse> {
    private static final SdkField<String> METADATA_TRANSFER_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadataTransferJobId").getter(CreateMetadataTransferJobResponse.getter(CreateMetadataTransferJobResponse::metadataTransferJobId)).setter(CreateMetadataTransferJobResponse.setter(Builder::metadataTransferJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateMetadataTransferJobResponse.getter(CreateMetadataTransferJobResponse::arn)).setter(CreateMetadataTransferJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(CreateMetadataTransferJobResponse.getter(CreateMetadataTransferJobResponse::creationDateTime)).setter(CreateMetadataTransferJobResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<MetadataTransferJobStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(CreateMetadataTransferJobResponse.getter(CreateMetadataTransferJobResponse::status)).setter(CreateMetadataTransferJobResponse.setter(Builder::status)).constructor(MetadataTransferJobStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_TRANSFER_JOB_ID_FIELD, ARN_FIELD, CREATION_DATE_TIME_FIELD, STATUS_FIELD));
    private final String metadataTransferJobId;
    private final String arn;
    private final Instant creationDateTime;
    private final MetadataTransferJobStatus status;

    private CreateMetadataTransferJobResponse(BuilderImpl builder) {
        super(builder);
        this.metadataTransferJobId = builder.metadataTransferJobId;
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.status = builder.status;
    }

    public final String metadataTransferJobId() {
        return this.metadataTransferJobId;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final MetadataTransferJobStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataTransferJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMetadataTransferJobResponse)) {
            return false;
        }
        CreateMetadataTransferJobResponse other = (CreateMetadataTransferJobResponse)((Object)obj);
        return Objects.equals(this.metadataTransferJobId(), other.metadataTransferJobId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMetadataTransferJobResponse").add("MetadataTransferJobId", (Object)this.metadataTransferJobId()).add("Arn", (Object)this.arn()).add("CreationDateTime", (Object)this.creationDateTime()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metadataTransferJobId": {
                return Optional.ofNullable(clazz.cast(this.metadataTransferJobId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMetadataTransferJobResponse, T> g) {
        return obj -> g.apply((CreateMetadataTransferJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private String metadataTransferJobId;
        private String arn;
        private Instant creationDateTime;
        private MetadataTransferJobStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMetadataTransferJobResponse model) {
            super(model);
            this.metadataTransferJobId(model.metadataTransferJobId);
            this.arn(model.arn);
            this.creationDateTime(model.creationDateTime);
            this.status(model.status);
        }

        public final String getMetadataTransferJobId() {
            return this.metadataTransferJobId;
        }

        public final void setMetadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
        }

        @Override
        public final Builder metadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final MetadataTransferJobStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(MetadataTransferJobStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(MetadataTransferJobStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateMetadataTransferJobResponse build() {
            return new CreateMetadataTransferJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMetadataTransferJobResponse> {
        public Builder metadataTransferJobId(String var1);

        public Builder arn(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder status(MetadataTransferJobStatus var1);

        default public Builder status(Consumer<MetadataTransferJobStatus.Builder> status) {
            return this.status((MetadataTransferJobStatus)((MetadataTransferJobStatus.Builder)MetadataTransferJobStatus.builder().applyMutation(status)).build());
        }
    }
}

