/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PricingTier {
    TIER_1("TIER_1"),
    TIER_2("TIER_2"),
    TIER_3("TIER_3"),
    TIER_4("TIER_4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PricingTier> VALUE_MAP;
    private final String value;

    private PricingTier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PricingTier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PricingTier> knownValues() {
        EnumSet<PricingTier> knownValues = EnumSet.allOf(PricingTier.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PricingTier.class, PricingTier::toString);
    }
}

