/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse;

public class GetPropertyValueHistoryPublisher
implements SdkPublisher<GetPropertyValueHistoryResponse> {
    private final IoTTwinMakerAsyncClient client;
    private final GetPropertyValueHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetPropertyValueHistoryPublisher(IoTTwinMakerAsyncClient client, GetPropertyValueHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetPropertyValueHistoryPublisher(IoTTwinMakerAsyncClient client, GetPropertyValueHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetPropertyValueHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetPropertyValueHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetPropertyValueHistoryResponseFetcher
    implements AsyncPageFetcher<GetPropertyValueHistoryResponse> {
        private GetPropertyValueHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetPropertyValueHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetPropertyValueHistoryResponse> nextPage(GetPropertyValueHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetPropertyValueHistoryPublisher.this.client.getPropertyValueHistory(GetPropertyValueHistoryPublisher.this.firstRequest);
            }
            return GetPropertyValueHistoryPublisher.this.client.getPropertyValueHistory((GetPropertyValueHistoryRequest)((Object)GetPropertyValueHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

