/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.DestinationConfiguration;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.SourceConfiguration;
import software.amazon.awssdk.services.iottwinmaker.model.SourceConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMetadataTransferJobRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, CreateMetadataTransferJobRequest> {
    private static final SdkField<String> METADATA_TRANSFER_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadataTransferJobId").getter(CreateMetadataTransferJobRequest.getter(CreateMetadataTransferJobRequest::metadataTransferJobId)).setter(CreateMetadataTransferJobRequest.setter(Builder::metadataTransferJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateMetadataTransferJobRequest.getter(CreateMetadataTransferJobRequest::description)).setter(CreateMetadataTransferJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<SourceConfiguration>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(CreateMetadataTransferJobRequest.getter(CreateMetadataTransferJobRequest::sources)).setter(CreateMetadataTransferJobRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DestinationConfiguration> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destination").getter(CreateMetadataTransferJobRequest.getter(CreateMetadataTransferJobRequest::destination)).setter(CreateMetadataTransferJobRequest.setter(Builder::destination)).constructor(DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_TRANSFER_JOB_ID_FIELD, DESCRIPTION_FIELD, SOURCES_FIELD, DESTINATION_FIELD));
    private final String metadataTransferJobId;
    private final String description;
    private final List<SourceConfiguration> sources;
    private final DestinationConfiguration destination;

    private CreateMetadataTransferJobRequest(BuilderImpl builder) {
        super(builder);
        this.metadataTransferJobId = builder.metadataTransferJobId;
        this.description = builder.description;
        this.sources = builder.sources;
        this.destination = builder.destination;
    }

    public final String metadataTransferJobId() {
        return this.metadataTransferJobId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<SourceConfiguration> sources() {
        return this.sources;
    }

    public final DestinationConfiguration destination() {
        return this.destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataTransferJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMetadataTransferJobRequest)) {
            return false;
        }
        CreateMetadataTransferJobRequest other = (CreateMetadataTransferJobRequest)((Object)obj);
        return Objects.equals(this.metadataTransferJobId(), other.metadataTransferJobId()) && Objects.equals(this.description(), other.description()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.destination(), other.destination());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMetadataTransferJobRequest").add("MetadataTransferJobId", (Object)this.metadataTransferJobId()).add("Description", (Object)this.description()).add("Sources", this.hasSources() ? this.sources() : null).add("Destination", (Object)this.destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metadataTransferJobId": {
                return Optional.ofNullable(clazz.cast(this.metadataTransferJobId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMetadataTransferJobRequest, T> g) {
        return obj -> g.apply((CreateMetadataTransferJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String metadataTransferJobId;
        private String description;
        private List<SourceConfiguration> sources = DefaultSdkAutoConstructList.getInstance();
        private DestinationConfiguration destination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMetadataTransferJobRequest model) {
            super(model);
            this.metadataTransferJobId(model.metadataTransferJobId);
            this.description(model.description);
            this.sources(model.sources);
            this.destination(model.destination);
        }

        public final String getMetadataTransferJobId() {
            return this.metadataTransferJobId;
        }

        public final void setMetadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
        }

        @Override
        public final Builder metadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SourceConfiguration.Builder> getSources() {
            List<SourceConfiguration.Builder> result = SourceConfigurationsCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<SourceConfiguration.BuilderImpl> sources) {
            this.sources = SourceConfigurationsCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<SourceConfiguration> sources) {
            this.sources = SourceConfigurationsCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(SourceConfiguration ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<SourceConfiguration.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (SourceConfiguration)((SourceConfiguration.Builder)SourceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DestinationConfiguration.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(DestinationConfiguration.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DestinationConfiguration destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMetadataTransferJobRequest build() {
            return new CreateMetadataTransferJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMetadataTransferJobRequest> {
        public Builder metadataTransferJobId(String var1);

        public Builder description(String var1);

        public Builder sources(Collection<SourceConfiguration> var1);

        public Builder sources(SourceConfiguration ... var1);

        public Builder sources(Consumer<SourceConfiguration.Builder> ... var1);

        public Builder destination(DestinationConfiguration var1);

        default public Builder destination(Consumer<DestinationConfiguration.Builder> destination) {
            return this.destination((DestinationConfiguration)((DestinationConfiguration.Builder)DestinationConfiguration.builder().applyMutation(destination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

