/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.DataValue;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertySummary> {
    private static final SdkField<PropertyDefinitionResponse> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(PropertySummary.getter(PropertySummary::definition)).setter(PropertySummary.setter(Builder::definition)).constructor(PropertyDefinitionResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyName").getter(PropertySummary.getter(PropertySummary::propertyName)).setter(PropertySummary.setter(Builder::propertyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyName").build()}).build();
    private static final SdkField<DataValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(PropertySummary.getter(PropertySummary::value)).setter(PropertySummary.setter(Builder::value)).constructor(DataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<Boolean> ARE_ALL_PROPERTY_VALUES_RETURNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("areAllPropertyValuesReturned").getter(PropertySummary.getter(PropertySummary::areAllPropertyValuesReturned)).setter(PropertySummary.setter(Builder::areAllPropertyValuesReturned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("areAllPropertyValuesReturned").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, PROPERTY_NAME_FIELD, VALUE_FIELD, ARE_ALL_PROPERTY_VALUES_RETURNED_FIELD));
    private static final long serialVersionUID = 1L;
    private final PropertyDefinitionResponse definition;
    private final String propertyName;
    private final DataValue value;
    private final Boolean areAllPropertyValuesReturned;

    private PropertySummary(BuilderImpl builder) {
        this.definition = builder.definition;
        this.propertyName = builder.propertyName;
        this.value = builder.value;
        this.areAllPropertyValuesReturned = builder.areAllPropertyValuesReturned;
    }

    public final PropertyDefinitionResponse definition() {
        return this.definition;
    }

    public final String propertyName() {
        return this.propertyName;
    }

    public final DataValue value() {
        return this.value;
    }

    public final Boolean areAllPropertyValuesReturned() {
        return this.areAllPropertyValuesReturned;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.areAllPropertyValuesReturned());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertySummary)) {
            return false;
        }
        PropertySummary other = (PropertySummary)obj;
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.propertyName(), other.propertyName()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.areAllPropertyValuesReturned(), other.areAllPropertyValuesReturned());
    }

    public final String toString() {
        return ToString.builder((String)"PropertySummary").add("Definition", (Object)this.definition()).add("PropertyName", (Object)this.propertyName()).add("Value", (Object)this.value()).add("AreAllPropertyValuesReturned", (Object)this.areAllPropertyValuesReturned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "propertyName": {
                return Optional.ofNullable(clazz.cast(this.propertyName()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "areAllPropertyValuesReturned": {
                return Optional.ofNullable(clazz.cast(this.areAllPropertyValuesReturned()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertySummary, T> g) {
        return obj -> g.apply((PropertySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PropertyDefinitionResponse definition;
        private String propertyName;
        private DataValue value;
        private Boolean areAllPropertyValuesReturned;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertySummary model) {
            this.definition(model.definition);
            this.propertyName(model.propertyName);
            this.value(model.value);
            this.areAllPropertyValuesReturned(model.areAllPropertyValuesReturned);
        }

        public final PropertyDefinitionResponse.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(PropertyDefinitionResponse.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PropertyDefinitionResponse definition) {
            this.definition = definition;
            return this;
        }

        public final String getPropertyName() {
            return this.propertyName;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public final DataValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(DataValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DataValue value) {
            this.value = value;
            return this;
        }

        public final Boolean getAreAllPropertyValuesReturned() {
            return this.areAllPropertyValuesReturned;
        }

        public final void setAreAllPropertyValuesReturned(Boolean areAllPropertyValuesReturned) {
            this.areAllPropertyValuesReturned = areAllPropertyValuesReturned;
        }

        @Override
        public final Builder areAllPropertyValuesReturned(Boolean areAllPropertyValuesReturned) {
            this.areAllPropertyValuesReturned = areAllPropertyValuesReturned;
            return this;
        }

        public PropertySummary build() {
            return new PropertySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertySummary> {
        public Builder definition(PropertyDefinitionResponse var1);

        default public Builder definition(Consumer<PropertyDefinitionResponse.Builder> definition) {
            return this.definition((PropertyDefinitionResponse)((PropertyDefinitionResponse.Builder)PropertyDefinitionResponse.builder().applyMutation(definition)).build());
        }

        public Builder propertyName(String var1);

        public Builder value(DataValue var1);

        default public Builder value(Consumer<DataValue.Builder> value) {
            return this.value((DataValue)((DataValue.Builder)DataValue.builder().applyMutation(value)).build());
        }

        public Builder areAllPropertyValuesReturned(Boolean var1);
    }
}

