/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.SceneCapabilitiesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.SceneMetadataMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSceneRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, UpdateSceneRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(UpdateSceneRequest.getter(UpdateSceneRequest::workspaceId)).setter(UpdateSceneRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final SdkField<String> SCENE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sceneId").getter(UpdateSceneRequest.getter(UpdateSceneRequest::sceneId)).setter(UpdateSceneRequest.setter(Builder::sceneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sceneId").build()}).build();
    private static final SdkField<String> CONTENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentLocation").getter(UpdateSceneRequest.getter(UpdateSceneRequest::contentLocation)).setter(UpdateSceneRequest.setter(Builder::contentLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLocation").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateSceneRequest.getter(UpdateSceneRequest::description)).setter(UpdateSceneRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilities").getter(UpdateSceneRequest.getter(UpdateSceneRequest::capabilities)).setter(UpdateSceneRequest.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SCENE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sceneMetadata").getter(UpdateSceneRequest.getter(UpdateSceneRequest::sceneMetadata)).setter(UpdateSceneRequest.setter(Builder::sceneMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, SCENE_ID_FIELD, CONTENT_LOCATION_FIELD, DESCRIPTION_FIELD, CAPABILITIES_FIELD, SCENE_METADATA_FIELD));
    private final String workspaceId;
    private final String sceneId;
    private final String contentLocation;
    private final String description;
    private final List<String> capabilities;
    private final Map<String, String> sceneMetadata;

    private UpdateSceneRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.sceneId = builder.sceneId;
        this.contentLocation = builder.contentLocation;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.sceneMetadata = builder.sceneMetadata;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String sceneId() {
        return this.sceneId;
    }

    public final String contentLocation() {
        return this.contentLocation;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilities() {
        return this.capabilities;
    }

    public final boolean hasSceneMetadata() {
        return this.sceneMetadata != null && !(this.sceneMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sceneMetadata() {
        return this.sceneMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSceneMetadata() ? this.sceneMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSceneRequest)) {
            return false;
        }
        UpdateSceneRequest other = (UpdateSceneRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.sceneId(), other.sceneId()) && Objects.equals(this.contentLocation(), other.contentLocation()) && Objects.equals(this.description(), other.description()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilities(), other.capabilities()) && this.hasSceneMetadata() == other.hasSceneMetadata() && Objects.equals(this.sceneMetadata(), other.sceneMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSceneRequest").add("WorkspaceId", (Object)this.workspaceId()).add("SceneId", (Object)this.sceneId()).add("ContentLocation", (Object)this.contentLocation()).add("Description", (Object)this.description()).add("Capabilities", this.hasCapabilities() ? this.capabilities() : null).add("SceneMetadata", this.hasSceneMetadata() ? this.sceneMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "sceneId": {
                return Optional.ofNullable(clazz.cast(this.sceneId()));
            }
            case "contentLocation": {
                return Optional.ofNullable(clazz.cast(this.contentLocation()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "sceneMetadata": {
                return Optional.ofNullable(clazz.cast(this.sceneMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSceneRequest, T> g) {
        return obj -> g.apply((UpdateSceneRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private String sceneId;
        private String contentLocation;
        private String description;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> sceneMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSceneRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.sceneId(model.sceneId);
            this.contentLocation(model.contentLocation);
            this.description(model.description);
            this.capabilities(model.capabilities);
            this.sceneMetadata(model.sceneMetadata);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getSceneId() {
            return this.sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        public final String getContentLocation() {
            return this.contentLocation;
        }

        public final void setContentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
        }

        @Override
        public final Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Map<String, String> getSceneMetadata() {
            if (this.sceneMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sceneMetadata;
        }

        public final void setSceneMetadata(Map<String, String> sceneMetadata) {
            this.sceneMetadata = SceneMetadataMapCopier.copy(sceneMetadata);
        }

        @Override
        public final Builder sceneMetadata(Map<String, String> sceneMetadata) {
            this.sceneMetadata = SceneMetadataMapCopier.copy(sceneMetadata);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSceneRequest build() {
            return new UpdateSceneRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSceneRequest> {
        public Builder workspaceId(String var1);

        public Builder sceneId(String var1);

        public Builder contentLocation(String var1);

        public Builder description(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder sceneMetadata(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

