/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class TabularPropertyValuesCopier {
    static List<List<Map<String, DataValue>>> copy(
            Collection<? extends Collection<? extends Map<String, ? extends DataValue>>> tabularPropertyValuesParam) {
        List<List<Map<String, DataValue>>> list;
        if (tabularPropertyValuesParam == null || tabularPropertyValuesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<List<Map<String, DataValue>>> modifiableList = new ArrayList<>();
            tabularPropertyValuesParam.forEach(entry -> {
                List<Map<String, DataValue>> list1;
                if (entry == null || entry instanceof SdkAutoConstructList) {
                    list1 = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Map<String, DataValue>> modifiableList1 = new ArrayList<>();
                    entry.forEach(entry1 -> {
                        Map<String, DataValue> map;
                        if (entry1 == null || entry1 instanceof SdkAutoConstructMap) {
                            map = DefaultSdkAutoConstructMap.getInstance();
                        } else {
                            Map<String, DataValue> modifiableMap = new LinkedHashMap<>();
                            entry1.forEach((key, value) -> {
                                modifiableMap.put(key, value);
                            });
                            map = Collections.unmodifiableMap(modifiableMap);
                        }
                        modifiableList1.add(map);
                    });
                    list1 = Collections.unmodifiableList(modifiableList1);
                }
                modifiableList.add(list1);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<List<Map<String, DataValue>>> copyFromBuilder(
            Collection<? extends Collection<? extends Map<String, ? extends DataValue.Builder>>> tabularPropertyValuesParam) {
        List<List<Map<String, DataValue>>> list;
        if (tabularPropertyValuesParam == null || tabularPropertyValuesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<List<Map<String, DataValue>>> modifiableList = new ArrayList<>();
            tabularPropertyValuesParam.forEach(entry -> {
                List<Map<String, DataValue>> list1;
                if (entry == null || entry instanceof SdkAutoConstructList) {
                    list1 = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Map<String, DataValue>> modifiableList1 = new ArrayList<>();
                    entry.forEach(entry1 -> {
                        Map<String, DataValue> map;
                        if (entry1 == null || entry1 instanceof SdkAutoConstructMap) {
                            map = DefaultSdkAutoConstructMap.getInstance();
                        } else {
                            Map<String, DataValue> modifiableMap = new LinkedHashMap<>();
                            entry1.forEach((key, value) -> {
                                DataValue member = value == null ? null : value.build();
                                modifiableMap.put(key, member);
                            });
                            map = Collections.unmodifiableMap(modifiableMap);
                        }
                        modifiableList1.add(map);
                    });
                    list1 = Collections.unmodifiableList(modifiableList1);
                }
                modifiableList.add(list1);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<List<Map<String, DataValue.Builder>>> copyToBuilder(
            Collection<? extends Collection<? extends Map<String, ? extends DataValue>>> tabularPropertyValuesParam) {
        List<List<Map<String, DataValue.Builder>>> list;
        if (tabularPropertyValuesParam == null || tabularPropertyValuesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<List<Map<String, DataValue.Builder>>> modifiableList = new ArrayList<>();
            tabularPropertyValuesParam.forEach(entry -> {
                List<Map<String, DataValue.Builder>> list1;
                if (entry == null || entry instanceof SdkAutoConstructList) {
                    list1 = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Map<String, DataValue.Builder>> modifiableList1 = new ArrayList<>();
                    entry.forEach(entry1 -> {
                        Map<String, DataValue.Builder> map;
                        if (entry1 == null || entry1 instanceof SdkAutoConstructMap) {
                            map = DefaultSdkAutoConstructMap.getInstance();
                        } else {
                            Map<String, DataValue.Builder> modifiableMap = new LinkedHashMap<>();
                            entry1.forEach((key, value) -> {
                                DataValue.Builder member = value == null ? null : value.toBuilder();
                                modifiableMap.put(key, member);
                            });
                            map = Collections.unmodifiableMap(modifiableMap);
                        }
                        modifiableList1.add(map);
                    });
                    list1 = Collections.unmodifiableList(modifiableList1);
                }
                modifiableList.add(list1);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
