/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SyncJobSummariesCopier {
    static List<SyncJobSummary> copy(Collection<? extends SyncJobSummary> syncJobSummariesParam) {
        List<SyncJobSummary> list;
        if (syncJobSummariesParam == null || syncJobSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SyncJobSummary> modifiableList = new ArrayList<>();
            syncJobSummariesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SyncJobSummary> copyFromBuilder(Collection<? extends SyncJobSummary.Builder> syncJobSummariesParam) {
        List<SyncJobSummary> list;
        if (syncJobSummariesParam == null || syncJobSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SyncJobSummary> modifiableList = new ArrayList<>();
            syncJobSummariesParam.forEach(entry -> {
                SyncJobSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SyncJobSummary.Builder> copyToBuilder(Collection<? extends SyncJobSummary> syncJobSummariesParam) {
        List<SyncJobSummary.Builder> list;
        if (syncJobSummariesParam == null || syncJobSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SyncJobSummary.Builder> modifiableList = new ArrayList<>();
            syncJobSummariesParam.forEach(entry -> {
                SyncJobSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
