/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.endpoints.internal;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.iottwinmaker.endpoints.IoTTwinMakerEndpointParams;
import software.amazon.awssdk.services.iottwinmaker.endpoints.IoTTwinMakerEndpointProvider;
import software.amazon.awssdk.services.iottwinmaker.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class IoTTwinMakerResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        IoTTwinMakerEndpointProvider provider = (IoTTwinMakerEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            Endpoint result = provider.resolveEndpoint(IoTTwinMakerResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = IoTTwinMakerResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), context.request())).isPresent()) {
                result = AwsEndpointProviderUtils.addHostPrefix(result, hostPrefix.get());
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    private static IoTTwinMakerEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        IoTTwinMakerEndpointParams.Builder builder = IoTTwinMakerEndpointParams.builder();
        IoTTwinMakerResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        IoTTwinMakerResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        return builder.build();
    }

    private static void setContextParams(IoTTwinMakerEndpointParams.Builder params, String operationName, SdkRequest request) {
        switch (operationName) {
            default: 
        }
    }

    private static void setStaticContextParams(IoTTwinMakerEndpointParams.Builder params, String operationName) {
        switch (operationName) {
            default: 
        }
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        switch (operationName) {
            case "BatchPutPropertyValues": {
                return Optional.of("data.");
            }
            case "CreateComponentType": {
                return Optional.of("api.");
            }
            case "CreateEntity": {
                return Optional.of("api.");
            }
            case "CreateScene": {
                return Optional.of("api.");
            }
            case "CreateSyncJob": {
                return Optional.of("api.");
            }
            case "CreateWorkspace": {
                return Optional.of("api.");
            }
            case "DeleteComponentType": {
                return Optional.of("api.");
            }
            case "DeleteEntity": {
                return Optional.of("api.");
            }
            case "DeleteScene": {
                return Optional.of("api.");
            }
            case "DeleteSyncJob": {
                return Optional.of("api.");
            }
            case "DeleteWorkspace": {
                return Optional.of("api.");
            }
            case "ExecuteQuery": {
                return Optional.of("api.");
            }
            case "GetComponentType": {
                return Optional.of("api.");
            }
            case "GetEntity": {
                return Optional.of("api.");
            }
            case "GetPricingPlan": {
                return Optional.of("api.");
            }
            case "GetPropertyValue": {
                return Optional.of("data.");
            }
            case "GetPropertyValueHistory": {
                return Optional.of("data.");
            }
            case "GetScene": {
                return Optional.of("api.");
            }
            case "GetSyncJob": {
                return Optional.of("api.");
            }
            case "GetWorkspace": {
                return Optional.of("api.");
            }
            case "ListComponentTypes": {
                return Optional.of("api.");
            }
            case "ListEntities": {
                return Optional.of("api.");
            }
            case "ListScenes": {
                return Optional.of("api.");
            }
            case "ListSyncJobs": {
                return Optional.of("api.");
            }
            case "ListSyncResources": {
                return Optional.of("api.");
            }
            case "ListTagsForResource": {
                return Optional.of("api.");
            }
            case "ListWorkspaces": {
                return Optional.of("api.");
            }
            case "TagResource": {
                return Optional.of("api.");
            }
            case "UntagResource": {
                return Optional.of("api.");
            }
            case "UpdateComponentType": {
                return Optional.of("api.");
            }
            case "UpdateEntity": {
                return Optional.of("api.");
            }
            case "UpdatePricingPlan": {
                return Optional.of("api.");
            }
            case "UpdateScene": {
                return Optional.of("api.");
            }
            case "UpdateWorkspace": {
                return Optional.of("api.");
            }
        }
        return Optional.empty();
    }
}

