/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParentEntityUpdateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParentEntityUpdateRequest> {
    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentEntityId").getter(ParentEntityUpdateRequest.getter(ParentEntityUpdateRequest::parentEntityId)).setter(ParentEntityUpdateRequest.setter(Builder::parentEntityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()}).build();
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateType").getter(ParentEntityUpdateRequest.getter(ParentEntityUpdateRequest::updateTypeAsString)).setter(ParentEntityUpdateRequest.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_ENTITY_ID_FIELD, UPDATE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parentEntityId;
    private final String updateType;

    private ParentEntityUpdateRequest(BuilderImpl builder) {
        this.parentEntityId = builder.parentEntityId;
        this.updateType = builder.updateType;
    }

    public final String parentEntityId() {
        return this.parentEntityId;
    }

    public final ParentEntityUpdateType updateType() {
        return ParentEntityUpdateType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParentEntityUpdateRequest)) {
            return false;
        }
        ParentEntityUpdateRequest other = (ParentEntityUpdateRequest)obj;
        return Objects.equals(this.parentEntityId(), other.parentEntityId()) && Objects.equals(this.updateTypeAsString(), other.updateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ParentEntityUpdateRequest").add("ParentEntityId", (Object)this.parentEntityId()).add("UpdateType", (Object)this.updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parentEntityId": {
                return Optional.ofNullable(clazz.cast(this.parentEntityId()));
            }
            case "updateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParentEntityUpdateRequest, T> g) {
        return obj -> g.apply((ParentEntityUpdateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parentEntityId;
        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(ParentEntityUpdateRequest model) {
            this.parentEntityId(model.parentEntityId);
            this.updateType(model.updateType);
        }

        public final String getParentEntityId() {
            return this.parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
        }

        @Override
        public final Builder parentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(ParentEntityUpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public ParentEntityUpdateRequest build() {
            return new ParentEntityUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParentEntityUpdateRequest> {
        public Builder parentEntityId(String var1);

        public Builder updateType(String var1);

        public Builder updateType(ParentEntityUpdateType var1);
    }
}

