/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentUpdateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentUpdateRequest> {
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(ComponentUpdateRequest.getter(ComponentUpdateRequest::componentTypeId)).setter(ComponentUpdateRequest.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ComponentUpdateRequest.getter(ComponentUpdateRequest::description)).setter(ComponentUpdateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, PropertyRequest>> PROPERTY_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyUpdates").getter(ComponentUpdateRequest.getter(ComponentUpdateRequest::propertyUpdates)).setter(ComponentUpdateRequest.setter(Builder::propertyUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyUpdates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateType").getter(ComponentUpdateRequest.getter(ComponentUpdateRequest::updateTypeAsString)).setter(ComponentUpdateRequest.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_TYPE_ID_FIELD, DESCRIPTION_FIELD, PROPERTY_UPDATES_FIELD, UPDATE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentTypeId;
    private final String description;
    private final Map<String, PropertyRequest> propertyUpdates;
    private final String updateType;

    private ComponentUpdateRequest(BuilderImpl builder) {
        this.componentTypeId = builder.componentTypeId;
        this.description = builder.description;
        this.propertyUpdates = builder.propertyUpdates;
        this.updateType = builder.updateType;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPropertyUpdates() {
        return this.propertyUpdates != null && !(this.propertyUpdates instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyRequest> propertyUpdates() {
        return this.propertyUpdates;
    }

    public final ComponentUpdateType updateType() {
        return ComponentUpdateType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyUpdates() ? this.propertyUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentUpdateRequest)) {
            return false;
        }
        ComponentUpdateRequest other = (ComponentUpdateRequest)obj;
        return Objects.equals(this.componentTypeId(), other.componentTypeId()) && Objects.equals(this.description(), other.description()) && this.hasPropertyUpdates() == other.hasPropertyUpdates() && Objects.equals(this.propertyUpdates(), other.propertyUpdates()) && Objects.equals(this.updateTypeAsString(), other.updateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentUpdateRequest").add("ComponentTypeId", (Object)this.componentTypeId()).add("Description", (Object)this.description()).add("PropertyUpdates", this.hasPropertyUpdates() ? this.propertyUpdates() : null).add("UpdateType", (Object)this.updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "propertyUpdates": {
                return Optional.ofNullable(clazz.cast(this.propertyUpdates()));
            }
            case "updateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentUpdateRequest, T> g) {
        return obj -> g.apply((ComponentUpdateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentTypeId;
        private String description;
        private Map<String, PropertyRequest> propertyUpdates = DefaultSdkAutoConstructMap.getInstance();
        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentUpdateRequest model) {
            this.componentTypeId(model.componentTypeId);
            this.description(model.description);
            this.propertyUpdates(model.propertyUpdates);
            this.updateType(model.updateType);
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, PropertyRequest.Builder> getPropertyUpdates() {
            Map<String, PropertyRequest.Builder> result = PropertyRequestsCopier.copyToBuilder(this.propertyUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyUpdates(Map<String, PropertyRequest.BuilderImpl> propertyUpdates) {
            this.propertyUpdates = PropertyRequestsCopier.copyFromBuilder(propertyUpdates);
        }

        @Override
        public final Builder propertyUpdates(Map<String, PropertyRequest> propertyUpdates) {
            this.propertyUpdates = PropertyRequestsCopier.copy(propertyUpdates);
            return this;
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(ComponentUpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public ComponentUpdateRequest build() {
            return new ComponentUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentUpdateRequest> {
        public Builder componentTypeId(String var1);

        public Builder description(String var1);

        public Builder propertyUpdates(Map<String, PropertyRequest> var1);

        public Builder updateType(String var1);

        public Builder updateType(ComponentUpdateType var1);
    }
}

