/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.SceneCapabilitiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSceneResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, GetSceneResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetSceneResponse.getter(GetSceneResponse::arn)).setter(GetSceneResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilities").getter(GetSceneResponse.getter(GetSceneResponse::capabilities)).setter(GetSceneResponse.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentLocation").getter(GetSceneResponse.getter(GetSceneResponse::contentLocation)).setter(GetSceneResponse.setter(Builder::contentLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLocation").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(GetSceneResponse.getter(GetSceneResponse::creationDateTime)).setter(GetSceneResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetSceneResponse.getter(GetSceneResponse::description)).setter(GetSceneResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SCENE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sceneId").getter(GetSceneResponse.getter(GetSceneResponse::sceneId)).setter(GetSceneResponse.setter(Builder::sceneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneId").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(GetSceneResponse.getter(GetSceneResponse::updateDateTime)).setter(GetSceneResponse.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(GetSceneResponse.getter(GetSceneResponse::workspaceId)).setter(GetSceneResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CAPABILITIES_FIELD, CONTENT_LOCATION_FIELD, CREATION_DATE_TIME_FIELD, DESCRIPTION_FIELD, SCENE_ID_FIELD, UPDATE_DATE_TIME_FIELD, WORKSPACE_ID_FIELD));
    private final String arn;
    private final List<String> capabilities;
    private final String contentLocation;
    private final Instant creationDateTime;
    private final String description;
    private final String sceneId;
    private final Instant updateDateTime;
    private final String workspaceId;

    private GetSceneResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.capabilities = builder.capabilities;
        this.contentLocation = builder.contentLocation;
        this.creationDateTime = builder.creationDateTime;
        this.description = builder.description;
        this.sceneId = builder.sceneId;
        this.updateDateTime = builder.updateDateTime;
        this.workspaceId = builder.workspaceId;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilities() {
        return this.capabilities;
    }

    public final String contentLocation() {
        return this.contentLocation;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final String description() {
        return this.description;
    }

    public final String sceneId() {
        return this.sceneId;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSceneResponse)) {
            return false;
        }
        GetSceneResponse other = (GetSceneResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.contentLocation(), other.contentLocation()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sceneId(), other.sceneId()) && Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"GetSceneResponse").add("Arn", (Object)this.arn()).add("Capabilities", this.hasCapabilities() ? this.capabilities() : null).add("ContentLocation", (Object)this.contentLocation()).add("CreationDateTime", (Object)this.creationDateTime()).add("Description", (Object)this.description()).add("SceneId", (Object)this.sceneId()).add("UpdateDateTime", (Object)this.updateDateTime()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "contentLocation": {
                return Optional.ofNullable(clazz.cast(this.contentLocation()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sceneId": {
                return Optional.ofNullable(clazz.cast(this.sceneId()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSceneResponse, T> g) {
        return obj -> g.apply((GetSceneResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private String contentLocation;
        private Instant creationDateTime;
        private String description;
        private String sceneId;
        private Instant updateDateTime;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSceneResponse model) {
            super(model);
            this.arn(model.arn);
            this.capabilities(model.capabilities);
            this.contentLocation(model.contentLocation);
            this.creationDateTime(model.creationDateTime);
            this.description(model.description);
            this.sceneId(model.sceneId);
            this.updateDateTime(model.updateDateTime);
            this.workspaceId(model.workspaceId);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final String getContentLocation() {
            return this.contentLocation;
        }

        public final void setContentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
        }

        @Override
        public final Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSceneId() {
            return this.sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public GetSceneResponse build() {
            return new GetSceneResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSceneResponse> {
        public Builder arn(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder contentLocation(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder description(String var1);

        public Builder sceneId(String var1);

        public Builder updateDateTime(Instant var1);

        public Builder workspaceId(String var1);
    }
}

