/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdatesMapRequestCopier;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEntityRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, UpdateEntityRequest> {
    private static final SdkField<Map<String, ComponentUpdateRequest>> COMPONENT_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("componentUpdates").getter(UpdateEntityRequest.getter(UpdateEntityRequest::componentUpdates)).setter(UpdateEntityRequest.setter(Builder::componentUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentUpdates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentUpdateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateEntityRequest.getter(UpdateEntityRequest::description)).setter(UpdateEntityRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(UpdateEntityRequest.getter(UpdateEntityRequest::entityId)).setter(UpdateEntityRequest.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityId").build()}).build();
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityName").getter(UpdateEntityRequest.getter(UpdateEntityRequest::entityName)).setter(UpdateEntityRequest.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()}).build();
    private static final SdkField<ParentEntityUpdateRequest> PARENT_ENTITY_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parentEntityUpdate").getter(UpdateEntityRequest.getter(UpdateEntityRequest::parentEntityUpdate)).setter(UpdateEntityRequest.setter(Builder::parentEntityUpdate)).constructor(ParentEntityUpdateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityUpdate").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(UpdateEntityRequest.getter(UpdateEntityRequest::workspaceId)).setter(UpdateEntityRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_UPDATES_FIELD, DESCRIPTION_FIELD, ENTITY_ID_FIELD, ENTITY_NAME_FIELD, PARENT_ENTITY_UPDATE_FIELD, WORKSPACE_ID_FIELD));
    private final Map<String, ComponentUpdateRequest> componentUpdates;
    private final String description;
    private final String entityId;
    private final String entityName;
    private final ParentEntityUpdateRequest parentEntityUpdate;
    private final String workspaceId;

    private UpdateEntityRequest(BuilderImpl builder) {
        super(builder);
        this.componentUpdates = builder.componentUpdates;
        this.description = builder.description;
        this.entityId = builder.entityId;
        this.entityName = builder.entityName;
        this.parentEntityUpdate = builder.parentEntityUpdate;
        this.workspaceId = builder.workspaceId;
    }

    public final boolean hasComponentUpdates() {
        return this.componentUpdates != null && !(this.componentUpdates instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentUpdateRequest> componentUpdates() {
        return this.componentUpdates;
    }

    public final String description() {
        return this.description;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityName() {
        return this.entityName;
    }

    public final ParentEntityUpdateRequest parentEntityUpdate() {
        return this.parentEntityUpdate;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentUpdates() ? this.componentUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentEntityUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEntityRequest)) {
            return false;
        }
        UpdateEntityRequest other = (UpdateEntityRequest)((Object)obj);
        return this.hasComponentUpdates() == other.hasComponentUpdates() && Objects.equals(this.componentUpdates(), other.componentUpdates()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityName(), other.entityName()) && Objects.equals(this.parentEntityUpdate(), other.parentEntityUpdate()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEntityRequest").add("ComponentUpdates", this.hasComponentUpdates() ? this.componentUpdates() : null).add("Description", (Object)this.description()).add("EntityId", (Object)this.entityId()).add("EntityName", (Object)this.entityName()).add("ParentEntityUpdate", (Object)this.parentEntityUpdate()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentUpdates": {
                return Optional.ofNullable(clazz.cast(this.componentUpdates()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
            case "parentEntityUpdate": {
                return Optional.ofNullable(clazz.cast(this.parentEntityUpdate()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEntityRequest, T> g) {
        return obj -> g.apply((UpdateEntityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private Map<String, ComponentUpdateRequest> componentUpdates = DefaultSdkAutoConstructMap.getInstance();
        private String description;
        private String entityId;
        private String entityName;
        private ParentEntityUpdateRequest parentEntityUpdate;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEntityRequest model) {
            super(model);
            this.componentUpdates(model.componentUpdates);
            this.description(model.description);
            this.entityId(model.entityId);
            this.entityName(model.entityName);
            this.parentEntityUpdate(model.parentEntityUpdate);
            this.workspaceId(model.workspaceId);
        }

        public final Map<String, ComponentUpdateRequest.Builder> getComponentUpdates() {
            Map<String, ComponentUpdateRequest.Builder> result = ComponentUpdatesMapRequestCopier.copyToBuilder(this.componentUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponentUpdates(Map<String, ComponentUpdateRequest.BuilderImpl> componentUpdates) {
            this.componentUpdates = ComponentUpdatesMapRequestCopier.copyFromBuilder(componentUpdates);
        }

        @Override
        public final Builder componentUpdates(Map<String, ComponentUpdateRequest> componentUpdates) {
            this.componentUpdates = ComponentUpdatesMapRequestCopier.copy(componentUpdates);
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityName() {
            return this.entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final ParentEntityUpdateRequest.Builder getParentEntityUpdate() {
            return this.parentEntityUpdate != null ? this.parentEntityUpdate.toBuilder() : null;
        }

        public final void setParentEntityUpdate(ParentEntityUpdateRequest.BuilderImpl parentEntityUpdate) {
            this.parentEntityUpdate = parentEntityUpdate != null ? parentEntityUpdate.build() : null;
        }

        @Override
        public final Builder parentEntityUpdate(ParentEntityUpdateRequest parentEntityUpdate) {
            this.parentEntityUpdate = parentEntityUpdate;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEntityRequest build() {
            return new UpdateEntityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEntityRequest> {
        public Builder componentUpdates(Map<String, ComponentUpdateRequest> var1);

        public Builder description(String var1);

        public Builder entityId(String var1);

        public Builder entityName(String var1);

        public Builder parentEntityUpdate(ParentEntityUpdateRequest var1);

        default public Builder parentEntityUpdate(Consumer<ParentEntityUpdateRequest.Builder> parentEntityUpdate) {
            return this.parentEntityUpdate((ParentEntityUpdateRequest)((ParentEntityUpdateRequest.Builder)ParentEntityUpdateRequest.builder().applyMutation(parentEntityUpdate)).build());
        }

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

