/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse;

public class ListScenesPublisher
implements SdkPublisher<ListScenesResponse> {
    private final IoTTwinMakerAsyncClient client;
    private final ListScenesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScenesPublisher(IoTTwinMakerAsyncClient client, ListScenesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScenesPublisher(IoTTwinMakerAsyncClient client, ListScenesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScenesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScenesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListScenesResponseFetcher
    implements AsyncPageFetcher<ListScenesResponse> {
        private ListScenesResponseFetcher() {
        }

        public boolean hasNextPage(ListScenesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScenesResponse> nextPage(ListScenesResponse previousPage) {
            if (previousPage == null) {
                return ListScenesPublisher.this.client.listScenes(ListScenesPublisher.this.firstRequest);
            }
            return ListScenesPublisher.this.client.listScenes((ListScenesRequest)((Object)ListScenesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

