/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyResponse;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyResponsesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentResponse> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(ComponentResponse.getter(ComponentResponse::componentName)).setter(ComponentResponse.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(ComponentResponse.getter(ComponentResponse::componentTypeId)).setter(ComponentResponse.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()}).build();
    private static final SdkField<String> DEFINED_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definedIn").getter(ComponentResponse.getter(ComponentResponse::definedIn)).setter(ComponentResponse.setter(Builder::definedIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definedIn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ComponentResponse.getter(ComponentResponse::description)).setter(ComponentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, PropertyResponse>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(ComponentResponse.getter(ComponentResponse::properties)).setter(ComponentResponse.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Status> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(ComponentResponse.getter(ComponentResponse::status)).setter(ComponentResponse.setter(Builder::status)).constructor(Status::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, COMPONENT_TYPE_ID_FIELD, DEFINED_IN_FIELD, DESCRIPTION_FIELD, PROPERTIES_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentName;
    private final String componentTypeId;
    private final String definedIn;
    private final String description;
    private final Map<String, PropertyResponse> properties;
    private final Status status;

    private ComponentResponse(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentTypeId = builder.componentTypeId;
        this.definedIn = builder.definedIn;
        this.description = builder.description;
        this.properties = builder.properties;
        this.status = builder.status;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final String definedIn() {
        return this.definedIn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyResponse> properties() {
        return this.properties;
    }

    public final Status status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.definedIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentResponse)) {
            return false;
        }
        ComponentResponse other = (ComponentResponse)obj;
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentTypeId(), other.componentTypeId()) && Objects.equals(this.definedIn(), other.definedIn()) && Objects.equals(this.description(), other.description()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentResponse").add("ComponentName", (Object)this.componentName()).add("ComponentTypeId", (Object)this.componentTypeId()).add("DefinedIn", (Object)this.definedIn()).add("Description", (Object)this.description()).add("Properties", this.hasProperties() ? this.properties() : null).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "definedIn": {
                return Optional.ofNullable(clazz.cast(this.definedIn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentResponse, T> g) {
        return obj -> g.apply((ComponentResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentName;
        private String componentTypeId;
        private String definedIn;
        private String description;
        private Map<String, PropertyResponse> properties = DefaultSdkAutoConstructMap.getInstance();
        private Status status;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentResponse model) {
            this.componentName(model.componentName);
            this.componentTypeId(model.componentTypeId);
            this.definedIn(model.definedIn);
            this.description(model.description);
            this.properties(model.properties);
            this.status(model.status);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getDefinedIn() {
            return this.definedIn;
        }

        public final void setDefinedIn(String definedIn) {
            this.definedIn = definedIn;
        }

        @Override
        public final Builder definedIn(String definedIn) {
            this.definedIn = definedIn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, PropertyResponse.Builder> getProperties() {
            Map<String, PropertyResponse.Builder> result = PropertyResponsesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, PropertyResponse.BuilderImpl> properties) {
            this.properties = PropertyResponsesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, PropertyResponse> properties) {
            this.properties = PropertyResponsesCopier.copy(properties);
            return this;
        }

        public final Status.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public ComponentResponse build() {
            return new ComponentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentResponse> {
        public Builder componentName(String var1);

        public Builder componentTypeId(String var1);

        public Builder definedIn(String var1);

        public Builder description(String var1);

        public Builder properties(Map<String, PropertyResponse> var1);

        public Builder status(Status var1);

        default public Builder status(Consumer<Status.Builder> status) {
            return this.status((Status)((Status.Builder)Status.builder().applyMutation(status)).build());
        }
    }
}

