/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyLatestValue;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyLatestValueMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPropertyValueResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, GetPropertyValueResponse> {
    private static final SdkField<Map<String, PropertyLatestValue>> PROPERTY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyValues").getter(GetPropertyValueResponse.getter(GetPropertyValueResponse::propertyValues)).setter(GetPropertyValueResponse.setter(Builder::propertyValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyLatestValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_VALUES_FIELD));
    private final Map<String, PropertyLatestValue> propertyValues;

    private GetPropertyValueResponse(BuilderImpl builder) {
        super(builder);
        this.propertyValues = builder.propertyValues;
    }

    public final boolean hasPropertyValues() {
        return this.propertyValues != null && !(this.propertyValues instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyLatestValue> propertyValues() {
        return this.propertyValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyValues() ? this.propertyValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPropertyValueResponse)) {
            return false;
        }
        GetPropertyValueResponse other = (GetPropertyValueResponse)((Object)obj);
        return this.hasPropertyValues() == other.hasPropertyValues() && Objects.equals(this.propertyValues(), other.propertyValues());
    }

    public final String toString() {
        return ToString.builder((String)"GetPropertyValueResponse").add("PropertyValues", this.hasPropertyValues() ? this.propertyValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "propertyValues": {
                return Optional.ofNullable(clazz.cast(this.propertyValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPropertyValueResponse, T> g) {
        return obj -> g.apply((GetPropertyValueResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private Map<String, PropertyLatestValue> propertyValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPropertyValueResponse model) {
            super(model);
            this.propertyValues(model.propertyValues);
        }

        public final Map<String, PropertyLatestValue.Builder> getPropertyValues() {
            Map<String, PropertyLatestValue.Builder> result = PropertyLatestValueMapCopier.copyToBuilder(this.propertyValues);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyValues(Map<String, PropertyLatestValue.BuilderImpl> propertyValues) {
            this.propertyValues = PropertyLatestValueMapCopier.copyFromBuilder(propertyValues);
        }

        @Override
        @Transient
        public final Builder propertyValues(Map<String, PropertyLatestValue> propertyValues) {
            this.propertyValues = PropertyLatestValueMapCopier.copy(propertyValues);
            return this;
        }

        @Override
        public GetPropertyValueResponse build() {
            return new GetPropertyValueResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPropertyValueResponse> {
        public Builder propertyValues(Map<String, PropertyLatestValue> var1);
    }
}

